/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.collect.CollectionBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class MapBuilder<K, V> {
    private final Map<K, V> map = new LinkedHashMap();

    public static <K, V> Map<K, V> emptyMap() {
        return new MapBuilder<K, V>().toMap();
    }

    public static <K, V> MapBuilder<K, V> newBuilder() {
        return new MapBuilder<K, V>();
    }

    public static <K, V> MapBuilder<K, V> newBuilder(K key, V value) {
        return new MapBuilder<K, V>().add(key, value);
    }

    public static <K, V> MapBuilder<K, V> newBuilder(K key1, V value1, K key2, V value2) {
        return new MapBuilder<K, V>().add(key1, value1).add(key2, value2);
    }

    public static <K, V> MapBuilder<K, V> newBuilder(K key1, V value1, K key2, V value2, K key3, V value3) {
        return new MapBuilder<K, V>().add(key1, value1).add(key2, value2).add(key3, value3);
    }

    public static <K, V> MapBuilder<K, V> newBuilder(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        return new MapBuilder<K, V>().add(key1, value1).add(key2, value2).add(key3, value3).add(key4, value4);
    }

    public static <K, V> MapBuilder<K, V> newBuilder(@Nullable Map<? extends K, ? extends V> map) {
        MapBuilder<? extends K, ? extends V> builder = MapBuilder.newBuilder();
        builder.addAll(map);
        return builder;
    }

    public static <K, V> Map<K, V> singletonMap(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    private MapBuilder() {
    }

    public static <K, V> Map<K, V> build(K key, V value) {
        return MapBuilder.newBuilder(key, value).toMap();
    }

    public static <K, V> Map<K, V> build(K key1, V value1, K key2, V value2) {
        return MapBuilder.newBuilder(key1, value1, key2, value2).toMap();
    }

    public static <K, V> Map<K, V> build(K key1, @Nullable V value1, K key2, @Nullable V value2, K key3, @Nullable V value3) {
        return MapBuilder.newBuilder(key1, value1, key2, value2, key3, value3).toMap();
    }

    public static <K, V> Map<K, V> build(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        return MapBuilder.newBuilder(key1, value1, key2, value2, key3, value3, key4, value4).toMap();
    }

    public MapBuilder<K, V> add(@Nullable K key, @Nullable V value) {
        this.map.put(key, value);
        return this;
    }

    public MapBuilder<K, V> addIfValueNotNull(K key, @Nullable V value) {
        if (value != null) {
            this.add(key, value);
        }
        return this;
    }

    public MapBuilder<K, V> addAll(@Nullable Map<? extends K, ? extends V> map) {
        if (map != null) {
            this.map.putAll(map);
        }
        return this;
    }

    public Map<K, V> toMap() {
        return Collections.unmodifiableMap(new HashMap<K, V>(this.map));
    }

    public HashMap<K, V> toHashMap() {
        return new HashMap<K, V>(this.map);
    }

    public LinkedHashMap<K, V> toLinkedHashMap() {
        return new LinkedHashMap<K, V>(this.map);
    }

    public Map<K, V> toListOrderedMap() {
        return Collections.unmodifiableMap(this.toLinkedHashMap());
    }

    public SortedMap<K, V> toSortedMap() {
        return Collections.unmodifiableSortedMap(this.toTreeMap());
    }

    public SortedMap<K, V> toSortedMap(Comparator<K> comparator) {
        return Collections.unmodifiableSortedMap(this.toTreeMap(comparator));
    }

    public TreeMap<K, V> toTreeMap() {
        return new TreeMap<K, V>(this.map);
    }

    public TreeMap<K, V> toTreeMap(Comparator<K> comparator) {
        TreeMap<K, V> result = new TreeMap<K, V>(comparator);
        result.putAll(this.map);
        return result;
    }

    public Map<K, V> toMutableMap() {
        return this.toHashMap();
    }

    public Map<K, V> toFastMap() {
        return ImmutableMap.copyOf(this.map);
    }

    public SortedMap<K, V> toFastSortedMap() {
        return this.toFastSortedMap(CollectionBuilder.natural());
    }

    public SortedMap<K, V> toFastSortedMap(Comparator<K> comparator) {
        return ImmutableSortedMap.copyOf(this.map, comparator);
    }

    @Deprecated
    public Map<K, V> toImmutableMap() {
        return this.toMap();
    }
}

