/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Functions;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.Predicates;
import com.atlassian.jira.util.collect.EnumerationIterator;
import com.atlassian.jira.util.collect.FilteredIterator;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.collect.TransformingIterator;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CollectionUtil {
    public static <T> void foreach(@NotNull Iterator<? extends T> iterator, @NotNull Consumer<T> consumer) {
        while (iterator.hasNext()) {
            consumer.consume(iterator.next());
        }
    }

    public static <T> void foreach(Iterable<T> iterable, @NotNull Consumer<T> consumer) {
        if (iterable != null) {
            CollectionUtil.foreach(iterable.iterator(), consumer);
        }
    }

    public static <T> List<T> toList(@NotNull Iterator<? extends T> iterator) {
        final ArrayList result = new ArrayList();
        CollectionUtil.foreach(iterator, new Consumer<T>(){

            @Override
            public void consume(T element) {
                result.add(element);
            }
        });
        return Collections.unmodifiableList(result);
    }

    public static <T> List<T> toList(@NotNull Iterable<? extends T> iterable) {
        return CollectionUtil.toList(iterable.iterator());
    }

    public static <T> List<T> toList(@NotNull Enumeration<? extends T> enumeration) {
        return CollectionUtil.toList(EnumerationIterator.fromEnumeration(enumeration));
    }

    public static <T> Set<T> toSet(@NotNull Iterable<? extends T> iterable) {
        return CollectionUtil.toSet(iterable.iterator());
    }

    public static <T> Set<T> toSet(@NotNull Iterator<? extends T> iterator) {
        return ImmutableSet.builder().addAll(iterator).build();
    }

    public static <T, R> List<R> transform(@NotNull Iterator<? extends T> iterator, @NotNull Function<T, R> transformer) {
        return CollectionUtil.toList(CollectionUtil.transformIterator(iterator, transformer));
    }

    public static <T, R> List<R> transform(@NotNull Iterable<? extends T> iterable, @NotNull Function<T, R> transformer) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return CollectionUtil.transform(iterable.iterator(), transformer);
    }

    public static <T, R> Iterator<R> transformIterator(@NotNull Iterator<? extends T> iterator, @NotNull Function<T, R> transformer) {
        return new TransformingIterator<T, R>(iterator, transformer);
    }

    public static <T, R> Set<R> transformSet(@NotNull Iterable<T> iterable, @NotNull Function<T, R> transformer) {
        return CollectionUtil.toSet(CollectionUtil.transformIterator(iterable.iterator(), transformer));
    }

    public static <T> boolean contains(@NotNull Iterator<? extends T> iterator, @NotNull Predicate<T> predicate) {
        return CollectionUtil.filter(iterator, predicate).hasNext();
    }

    public static <T> boolean contains(@NotNull Iterable<? extends T> iterable, @NotNull Predicate<T> predicate) {
        return CollectionUtil.contains(iterable.iterator(), predicate);
    }

    public static <T> Iterator<T> filter(@NotNull Iterator<T> iterator, @NotNull Predicate<? super T> predicate) {
        return new FilteredIterator<T>(iterator, predicate);
    }

    public static <T> Iterable<T> filter(@NotNull Iterable<T> iterable, @NotNull Predicate<? super T> predicate) {
        return new FilteredIterable<T>(iterable, predicate);
    }

    public static <T, R> Iterable<R> transformAndFilter(Iterable<T> iterable, Function<T, R> transformer, Predicate<R> predicate) {
        return CollectionUtil.filter(CollectionUtil.transform(iterable, transformer), predicate);
    }

    public static <T> Collection<T> filter(@NotNull Collection<T> collection, @NotNull Predicate<? super T> predicate) {
        return Collections2.filter(collection, CollectionUtil.predicateAdapter(predicate));
    }

    public static <T, R extends T> Collection<R> filterByType(@NotNull Iterable<T> iterable, @NotNull Class<R> subclass) {
        return CollectionUtil.transform(CollectionUtil.filter(iterable, Predicates.isInstanceOf(subclass)), Functions.downcast(subclass));
    }

    public static <T> List<T> sort(@NotNull Collection<? extends T> collection, @NotNull Comparator<T> comparator) {
        Assertions.notNull("collection", collection);
        Assertions.notNull("comparator", comparator);
        ArrayList<T> sorted = new ArrayList<T>(collection);
        if (sorted.size() > 1) {
            Collections.sort(sorted, comparator);
        }
        return Collections.unmodifiableList(sorted);
    }

    public static <T> List<T> copyAsImmutableList(@NotNull Collection<? extends T> copy) {
        Assertions.notNull("copy", copy);
        if (copy.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(copy));
    }

    public static <T> Set<T> copyAsImmutableSet(@NotNull Collection<? extends T> copy) {
        Assertions.notNull("copy", copy);
        if (copy.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<T>(copy));
    }

    public static <K, V> Map<K, V> copyAsImmutableMap(@NotNull Map<? extends K, ? extends V> copy) {
        Assertions.notNull("copy", copy);
        if (copy.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new HashMap<K, V>(copy));
    }

    public static <T> T findFirstMatch(@NotNull Iterable<? extends T> iterable, Predicate<T> predicate) {
        Assertions.notNull("iterable", iterable);
        Assertions.notNull("predicate", predicate);
        for (T t : iterable) {
            if (!predicate.evaluate(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> int indexOf(@NotNull Iterable<? extends T> iterable, @NotNull Predicate<? super T> predicate) {
        Assertions.notNull("iterable", iterable);
        Assertions.notNull("predicate", predicate);
        Iterator<T> iterator = iterable.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (predicate.evaluate(iterator.next())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> T first(@NotNull Iterable<? extends T> iterable) {
        Iterator<T> iterator = iterable.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static <K, R, S> Map<K, S> map(Map<K, R> map, Function<R, S> mapper) {
        MapBuilder<K, S> builder = MapBuilder.newBuilder();
        for (Map.Entry<K, R> entry : map.entrySet()) {
            builder.add(entry.getKey(), mapper.get(entry.getValue()));
        }
        return builder.toMap();
    }

    static <T> com.google.common.base.Predicate<T> predicateAdapter(Predicate<T> predicate) {
        return new GCollectPredicate<T>(predicate);
    }

    static class GCollectPredicate<T>
    implements com.google.common.base.Predicate<T> {
        private final Predicate<T> delegate;

        public GCollectPredicate(Predicate<T> delegate) {
            this.delegate = delegate;
        }

        public boolean apply(T input) {
            return this.delegate.evaluate(input);
        }
    }

    static class FilteredIterable<T>
    implements Iterable<T> {
        private final Iterable<T> delegate;
        private final Predicate<? super T> predicate;

        FilteredIterable(Iterable<T> delegate, Predicate<? super T> predicate) {
            this.delegate = Assertions.notNull("delegate", delegate);
            this.predicate = Assertions.notNull("predicate", predicate);
        }

        @Override
        public Iterator<T> iterator() {
            return new FilteredIterator<T>(this.delegate.iterator(), this.predicate);
        }
    }
}

