/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.serialize;

import electric.util.Value;
import electric.util.classloader.ClassLoaders;
import electric.util.string.Base64;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class SerializeType
extends Type {
    static /* synthetic */ Class class$electric$xml$io$ISerializable;

    public SerializeType() {
    }

    public SerializeType(Namespaces namespaces, String namespace, String name, Class javaClass) {
        this.setSchema(namespaces.findSchema(namespace));
        this.setName(name);
        this.setJavaClass(javaClass);
    }

    public String toString() {
        try {
            return "SerializeType( class=" + this.getJavaClass() + " )";
        }
        catch (SchemaException exception) {
            return "SerializeType( " + exception + " )";
        }
    }

    public boolean isStandard() {
        return this.getNamespaces() == null;
    }

    public void writeSchema(Element schema) throws SchemaException {
        String xsdPrefix = Type.getXSDPrefix(schema);
        String tmePrefix = schema.getPrefix(SchemaProperties.getTmeNamespace(), "tme");
        Element complexType = schema.addElement(xsdPrefix, "complexType");
        complexType.setAttribute("name", this.getName());
        Element complexContent = complexType.addElement(xsdPrefix, "complexContent");
        Element restriction = complexContent.addElement(xsdPrefix, "restriction");
        restriction.setAttribute("base", tmePrefix + ":java");
        Element attribute = restriction.addElement(xsdPrefix, "attribute");
        attribute.setAttribute("ref", tmePrefix + ":class");
        attribute.setAttribute(tmePrefix, "class", this.getJavaName());
    }

    public void writeType(IWriter writer) throws IOException {
        String xsiPrefix = writer.getElement().getPrefix(writer.getVersion() + "-instance", "xsi");
        String tmePrefix = writer.getElement().getPrefix(SchemaProperties.getTmeNamespace(), "tme");
        writer.writeAttribute(xsiPrefix, "type", tmePrefix + ":java");
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        String tmePrefix = writer.getElement().getPrefix(SchemaProperties.getTmeNamespace(), "tme");
        writer.writeAttribute(tmePrefix, "class", object.getClass().getName());
        if (object instanceof ISerializable) {
            ((ISerializable)object).write(writer);
        } else {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(buffer);
            output.writeObject(object);
            writer.writeText(Base64.toBase64(buffer.toByteArray()));
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        try {
            String className = reader.readAttributeValue("class");
            Class type = ClassLoaders.loadClass(className);
            if ((class$electric$xml$io$ISerializable == null ? (class$electric$xml$io$ISerializable = SerializeType.class$("electric.xml.io.ISerializable")) : class$electric$xml$io$ISerializable).isAssignableFrom(type)) {
                ISerializable object = (ISerializable)type.newInstance();
                value.setObject(object);
                Element element = reader.getElement();
                if (element.hasElements()) {
                    object.read(reader.getReaderAt(1));
                }
            } else {
                byte[] bytes = Base64.fromBase64(reader.readText());
                ByteArrayInputStream buffer = new ByteArrayInputStream(bytes);
                ObjectInputStream input = new ObjectInputStream(buffer);
                value.setObject(input.readObject());
            }
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new IOException(exception.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

