/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.encoded;

import electric.util.ids.IIDGenerator;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Text;
import electric.xml.io.IWriter;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.encoded.Ids;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaAttribute;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;

public final class EncodedWriter
implements IWriter,
ISchemaConstants {
    private Element element;
    private Namespaces namespaces;
    private Ids ids;
    private boolean disableTypeOmissions;
    private String encodingStyle;
    private boolean soap12refs = false;

    public EncodedWriter(String name) {
        this(name, SchemaProperties.getDefaultSchema(), "http://schemas.xmlsoap.org/soap/encoding/");
    }

    public EncodedWriter(String name, String version) {
        this(name, version, "http://schemas.xmlsoap.org/soap/encoding/");
    }

    public EncodedWriter(String name, String version, String encodingStyle) {
        Document document = new Document();
        this.encodingStyle = encodingStyle;
        this.init(document.setRoot(name), version);
    }

    public EncodedWriter(Element element) {
        this(element, SchemaProperties.getDefaultSchema(), "http://schemas.xmlsoap.org/soap/encoding/");
    }

    public EncodedWriter(Element element, String version) {
        this(element, version, "http://schemas.xmlsoap.org/soap/encoding/");
    }

    public EncodedWriter(Element element, String version, String encodingStyle) {
        this.encodingStyle = encodingStyle;
        this.init(element, version);
    }

    public EncodedWriter(Element element, Namespaces namespaces) {
        this(element, namespaces, null);
    }

    public EncodedWriter(Element element, Namespaces namespaces, Element root) {
        this(element, namespaces, root, false);
    }

    public EncodedWriter(Element element, Namespaces namespaces, Element root, boolean disableTypeOmissions) {
        this(element, namespaces, root, disableTypeOmissions, null);
    }

    public EncodedWriter(Element element, Namespaces namespaces, Element root, boolean disableTypeOmissions, String encodingStyle) {
        this.element = element;
        this.namespaces = namespaces;
        this.disableTypeOmissions = disableTypeOmissions;
        this.encodingStyle = encodingStyle;
        if (encodingStyle != null && encodingStyle.equals("http://www.w3.org/2003/05/soap-encoding")) {
            this.soap12refs = true;
        }
        this.ids = this.soap12refs ? new Ids(null, this.soap12refs) : new Ids(root, this.soap12refs);
    }

    private EncodedWriter(Element element, EncodedWriter writer) {
        this.element = element;
        this.namespaces = writer.namespaces;
        this.ids = writer.ids;
        this.disableTypeOmissions = writer.disableTypeOmissions;
        this.encodingStyle = writer.encodingStyle;
        this.soap12refs = writer.soap12refs;
    }

    private void init(Element element, String version) {
        this.element = element;
        this.namespaces = new Namespaces(SchemaProperties.getDefaultSchema(), this.encodingStyle);
        this.ids = new Ids(null, false);
        element.setNamespace("xsi", version + "-instance");
        element.setNamespace("xsd", version);
    }

    public String getVersion() {
        return this.namespaces.getVersion();
    }

    public Document getDocument() {
        return this.element.getDocument();
    }

    public Element getElement() {
        return this.element;
    }

    public IWriter writeElement() {
        return new EncodedWriter(this.element.addElement(), this);
    }

    public IWriter writeElement(String name) {
        return new EncodedWriter(this.element.addElement(name), this);
    }

    public IWriter writeElement(String prefix, String name) {
        return new EncodedWriter(this.element.addElement(prefix, name), this);
    }

    public IWriter writeElement(Element newElement) {
        return new EncodedWriter(this.element.addElement(newElement), this);
    }

    public IWriter writeName(String name) {
        this.element.setName(name);
        return this;
    }

    public IWriter writeName(String prefix, String name) {
        this.element.setName(prefix, name);
        return this;
    }

    public IWriter writeAttribute(String name, String value) {
        this.element.setAttribute(name, value);
        return this;
    }

    public IWriter writeAttribute(String prefix, String name, String value) {
        this.element.setAttribute(prefix, name, value);
        return this;
    }

    public IWriter writeNamespace(String prefix, String value) {
        this.element.setNamespace(prefix, value);
        return this;
    }

    public IWriter writeType(Type type) throws IOException {
        return this.writeType(type.getName(this.element));
    }

    public IWriter writeType(String type) throws IOException {
        this.element.setAttribute("xsi", "type", type);
        return this;
    }

    public Type getType(Class javaClass) throws SchemaException {
        return this.namespaces.getTypeWithJavaClass(javaClass);
    }

    public boolean getTypeOmissionDisabled() {
        return this.disableTypeOmissions;
    }

    public void setDisableTypeOmissions(boolean disableTypeOmissions) {
        this.disableTypeOmissions = disableTypeOmissions;
    }

    public void writeText(String value) {
        if (value != null) {
            this.element.addChild(new Text(value));
        }
    }

    public void writeBoolean(boolean value) {
        this.element.setBoolean(value);
    }

    public void writeBoolean(String name, boolean value) {
        this.element.addElement(name).setBoolean(value);
    }

    public void writeChar(char value) {
        this.element.setChar(value);
    }

    public void writeChar(String name, char value) {
        this.element.addElement(name).setChar(value);
    }

    public void writeByte(byte value) {
        this.element.setByte(value);
    }

    public void writeByte(String name, byte value) {
        this.element.addElement(name).setByte(value);
    }

    public void writeShort(short value) {
        this.element.setShort(value);
    }

    public void writeShort(String name, short value) {
        this.element.addElement(name).setShort(value);
    }

    public void writeInt(int value) {
        this.element.setInt(value);
    }

    public void writeInt(String name, int value) {
        this.element.addElement(name).setInt(value);
    }

    public void writeLong(long value) {
        this.element.setLong(value);
    }

    public void writeLong(String name, long value) {
        this.element.addElement(name).setLong(value);
    }

    public void writeFloat(float value) {
        this.element.setFloat(value);
    }

    public void writeFloat(String name, float value) {
        this.element.addElement(name).setFloat(value);
    }

    public void writeDouble(double value) {
        this.element.setDouble(value);
    }

    public void writeDouble(String name, double value) {
        this.element.addElement(name).setDouble(value);
    }

    public void writeString(String name, String value) {
        Element child = this.element.addElement(name);
        if (value != null) {
            child.addChild(new Text(value));
        }
    }

    public void writeString(String value) {
        if (value != null) {
            this.element.addChild(new Text(value));
        }
    }

    public void writeNil() {
        this.element.setAttribute("xsi", "nil", "1");
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNil();
        } else {
            this.write(object, this.getType(object.getClass()), null, false);
        }
    }

    public void writeObject(Object object, Type formalType) throws IOException {
        if (object == null) {
            this.writeNil();
        } else {
            this.write(object, formalType.getRuntimeType(object, this.namespaces), formalType, false);
        }
    }

    public void writeObject(String name, Object object, Type formalType) throws IOException {
        this.writeElement(name).writeObject(object, formalType);
    }

    public void writeObject(String prefix, String name, Object object, Type formalType) throws IOException {
        this.writeElement(prefix, name).writeObject(object, formalType);
    }

    public void writeObject(String name, Object object) throws IOException {
        this.writeElement(name).writeObject(object);
    }

    public void writeObject(String prefix, String name, Object object) throws IOException {
        this.writeElement(prefix, name).writeObject(object);
    }

    public void writeObjectDisablingTypeOmission(String name, Object object, Type formalType) throws IOException {
        EncodedWriter childWriter = new EncodedWriter(this.element.addElement(name), this);
        if (object == null) {
            childWriter.writeNil();
        } else {
            childWriter.write(object, formalType.getRuntimeType(object, this.namespaces), formalType, true);
        }
    }

    public void writeObjectDisablingTypeOmission(String prefix, String name, Object object, Type formalType) throws IOException {
        EncodedWriter childWriter = new EncodedWriter(this.element.addElement(prefix, name), this);
        if (object == null) {
            childWriter.writeNil();
        } else {
            childWriter.write(object, formalType.getRuntimeType(object, this.namespaces), formalType, true);
        }
    }

    private void write(Object object, Type actualType, Type formalType, boolean disableTypeOmission) throws IOException {
        if (!actualType.isMultiReference()) {
            if (disableTypeOmission || !actualType.equals(formalType)) {
                actualType.writeType(this);
            }
            actualType.writeObject(this, object);
            return;
        }
        if (object instanceof IIDGenerator) {
            String id = ((IIDGenerator)object).generateId();
            this.emitRef(id);
            this.ids.addId(object, id);
            return;
        }
        Object id = this.ids.getId(object);
        if (id != null) {
            this.emitPoundRef(id);
            return;
        }
        id = this.ids.newId(object, this.element);
        if (disableTypeOmission || !actualType.equals(formalType)) {
            actualType.writeType(this);
        }
        actualType.writeObject(this, object);
    }

    private void emitRef(String id) {
        if (this.soap12refs) {
            this.writeAttribute("soapenc", "ref", id);
        } else {
            this.writeAttribute("href", id);
        }
    }

    private void emitPoundRef(Object id) {
        if (this.soap12refs) {
            this.writeAttribute("soapenc", "ref", "id" + id);
        } else {
            this.writeAttribute("href", "#id" + id);
        }
    }

    public void writeObject(SchemaElement element, Object object) throws IOException {
        element.writeObject(this, object);
    }

    public void writeObject(SchemaAttribute attribute, Object object) throws IOException {
        attribute.writeObject(this, object);
    }
}

