/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb.server;

import electric.xdb.IXDBConstants;

public class Member
implements IXDBConstants {
    private String name;
    private String url;
    private boolean online = true;
    private int lastSyncedTag;
    private boolean leader;
    private transient boolean modified;
    private transient boolean stateChanged;

    public Member() {
    }

    public Member(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public String toString() {
        return "Member( name=" + this.name + ", url=" + this.url + ", online=" + this.online + ", lastSyncedTag=" + this.lastSyncedTag + ", leader=" + this.leader + " )";
    }

    public String getName() {
        return this.name;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        if (url.equals(this.url)) {
            return;
        }
        this.url = url;
        this.modified = true;
    }

    public int getLastSyncedTag() {
        return this.lastSyncedTag;
    }

    public synchronized void setLastSyncedTag(int lastSyncedTag) {
        if (this.lastSyncedTag >= lastSyncedTag) {
            return;
        }
        this.lastSyncedTag = lastSyncedTag;
        this.modified = true;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public synchronized void setLeader(boolean leader) {
        if (this.leader == leader) {
            return;
        }
        this.leader = leader;
        this.modified = true;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void setOffline() {
        this.setOnline(false);
    }

    public void setOnline() {
        this.setOnline(true);
    }

    public void setOnline(boolean online) {
        if (this.online == online) {
            return;
        }
        this.online = online;
        this.modified = true;
        this.stateChanged = true;
    }

    public boolean isStateChanged() {
        return this.stateChanged;
    }

    public void resetStateChanged() {
        this.stateChanged = false;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void resetModified() {
        this.modified = false;
    }
}

