/*
 * Decompiled with CFR 0.152.
 */
package electric.xdb.client;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.ServiceInfo;
import electric.registry.Registry;
import electric.util.array.ArrayUtil;
import electric.util.log.Log;
import electric.util.proxy.ProxyFactory;
import electric.wsdl.util.SignatureGenerator;
import electric.xdb.IXDBConstants;
import electric.xdb.XDBException;
import electric.xdb.client.XDBClient;
import electric.xdb.server.IXDBServer;
import electric.xdb.server.IXDBServersListener;
import electric.xdb.server.LocalXDBServerFactory;
import electric.xdb.server.LocalXDBServers;
import electric.xdb.server.XDBServer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

class XDBProxy
implements InvocationHandler,
IXDBServersListener,
IXDBConstants,
IFabricConstants {
    private XDBClient client;
    private String url;
    private Class[] interfaces;
    private IXDBServer server;
    private IXDBServer serverInterface;
    private String signature;
    static /* synthetic */ Class class$electric$xdb$server$IXDBServer;

    public XDBProxy(XDBClient client) {
        this.client = client;
        this.interfaces = new Class[]{class$electric$xdb$server$IXDBServer == null ? (class$electric$xdb$server$IXDBServer = XDBProxy.class$("electric.xdb.server.IXDBServer")) : class$electric$xdb$server$IXDBServer};
        LocalXDBServers.addListener(this);
        ClassLoader loader = this.getClass().getClassLoader();
        this.serverInterface = (IXDBServer)ProxyFactory.newProxy(loader, this.interfaces, this);
        this.signature = SignatureGenerator.getDocLitSignature(class$electric$xdb$server$IXDBServer == null ? (class$electric$xdb$server$IXDBServer = XDBProxy.class$("electric.xdb.server.IXDBServer")) : class$electric$xdb$server$IXDBServer);
    }

    public IXDBServer getServer() {
        return this.serverInterface;
    }

    public String getGroup() {
        return this.client.getGroup();
    }

    public String getURL() {
        return this.url;
    }

    public synchronized void setServer(String url, IXDBServer server) {
        if (Log.isLogging(IXDBConstants.XDB_CLIENT_EVENT)) {
            Log.log(IXDBConstants.XDB_CLIENT_EVENT, (Object)("set xdb server url for group " + this.getGroup() + " to " + url));
        }
        this.url = url;
        this.server = server;
    }

    public synchronized void clearServer() {
        if (Log.isLogging(IXDBConstants.XDB_CLIENT_EVENT)) {
            Log.log(IXDBConstants.XDB_CLIENT_EVENT, (Object)("reset xdb server url for group " + this.getGroup()));
        }
        this.url = null;
        this.server = null;
    }

    public synchronized void findOrCreateServer() throws Exception {
        if (this.url != null) {
            return;
        }
        this.findServer();
        if (this.url != null) {
            return;
        }
        this.createServer();
        if (this.url == null) {
            throw new XDBException("could not locate xdb server for group " + this.getGroup());
        }
    }

    private void findServer() {
        if (Log.isLogging(IXDBConstants.XDB_CLIENT_EVENT)) {
            Log.log(IXDBConstants.XDB_CLIENT_EVENT, (Object)("find xdb servers for group " + this.getGroup()));
        }
        ServiceInfo[] serviceInfos = this.findServersInGroup();
        int i = 0;
        while (i < serviceInfos.length) {
            try {
                String url = serviceInfos[i].getWSDLURL();
                if (Log.isLogging(IXDBConstants.XDB_CLIENT_EVENT)) {
                    Log.log(IXDBConstants.XDB_CLIENT_EVENT, (Object)("try xdb server " + url));
                }
                IXDBServer server = (IXDBServer)Registry.bind(url, this.interfaces);
                server.ping();
                this.setServer(url, server);
                return;
            }
            catch (Exception exception) {
                ++i;
            }
        }
    }

    private ServiceInfo[] findServersInGroup() {
        try {
            String path = "?glue&service.signature=" + this.signature + "&" + "service.group" + "=" + this.getGroup();
            ServiceInfo[] serviceInfos = Fabric.getServiceManager().findServicesForPath(path);
            return (ServiceInfo[])ArrayUtil.randomizeOrder(serviceInfos);
        }
        catch (Exception exception) {
            return new ServiceInfo[0];
        }
    }

    private void createServer() throws Exception {
        if (Fabric.isServer()) {
            this.createLocalServer();
        } else {
            this.createRemoteServer();
        }
    }

    private void createLocalServer() throws XDBException {
        String group = this.getGroup();
        int replicationFactor = XDBServer.getDefaultReplicationFactor();
        if (Log.isLogging(IXDBConstants.XDB_CLIENT_EVENT)) {
            Log.log(IXDBConstants.XDB_CLIENT_EVENT, (Object)("create local xdb server for group " + group));
        }
        LocalXDBServerFactory.getServer(group, replicationFactor);
    }

    private void createRemoteServer() throws Exception {
        String group = this.getGroup();
        int replicationFactor = XDBServer.getDefaultReplicationFactor();
        if (Log.isLogging(IXDBConstants.XDB_CLIENT_EVENT)) {
            Log.log(IXDBConstants.XDB_CLIENT_EVENT, (Object)("create remote xdb server for group " + group));
        }
        String path = "?glue&service.signature=" + this.signature + "&" + "service.group" + "=" + group + "&" + "service.replicationFactor" + "=" + replicationFactor;
        ServiceInfo serviceInfo = Fabric.getServiceManager().createService(path);
        if (serviceInfo == null) {
            return;
        }
        String url = serviceInfo.getWSDLURL();
        IXDBServer server = (IXDBServer)Registry.bind(url, this.interfaces);
        this.setServer(url, server);
    }

    public void addedLocalServer(IXDBServer server) {
        try {
            if (server.getGroup().equals(this.getGroup())) {
                this.setServer(server.getServerInfo().getURL(), server);
            }
        }
        catch (XDBException exception) {}
    }

    public void removedLocalServer(IXDBServer server) {
        try {
            if (server.getGroup().equals(this.getGroup())) {
                this.clearServer();
            }
        }
        catch (XDBException exception) {}
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.url != null) {
            try {
                return method.invoke((Object)this.server, args);
            }
            catch (Exception exception) {
                this.clearServer();
            }
        }
        this.findOrCreateServer();
        try {
            return method.invoke((Object)this.server, args);
        }
        catch (Exception exception) {
            this.clearServer();
            throw exception;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

