/*
 * Decompiled with CFR 0.152.
 */
package electric.util.constructor;

import electric.util.classloader.ClassLoaders;
import electric.util.constructor.IInstantiator;
import electric.util.reflect.Reflect;
import electric.xml.Element;
import electric.xml.Elements;

public class Factory
implements IInstantiator {
    public String methodName;
    public String[] args = new String[0];
    public String className;
    private transient Class factoryClass;
    private transient ClassLoader loader;

    public Factory() {
    }

    public Factory(String methodName) {
        this.methodName = methodName;
    }

    public Factory(String className, String methodName, String[] args) {
        this.className = className;
        this.methodName = methodName;
        this.args = args;
    }

    public Factory(Element element) {
        this.className = element.getElement("class").getString();
        this.args = Factory.getArgs(element);
        this.methodName = element.getElement("method").getString();
    }

    public Object newInstance() throws Throwable {
        if (this.factoryClass == null) {
            this.factoryClass = ClassLoaders.loadClass(this.className, this.loader);
        }
        return Reflect.invoke(this.factoryClass, this.methodName, this.args);
    }

    public void writeDescriptor(Element descriptor) {
        Element constructor = descriptor.addElement("factory");
        constructor.addElement("class").setText(this.className);
        constructor.addElement("method").setText(this.methodName);
        Element argsElement = constructor.addElement("args");
        int i = 0;
        while (i < this.args.length) {
            argsElement.addElement("arg").setText(this.args[i]);
            ++i;
        }
    }

    public Element getDescriptor() {
        Element factory = new Element("factory");
        factory.addElement("class").setText(this.className);
        factory.addElement("method").setText(this.methodName);
        Element argsElement = factory.addElement("args");
        int i = 0;
        while (i < this.args.length) {
            argsElement.addElement("arg").setText(this.args[i]);
            ++i;
        }
        return factory;
    }

    protected static String[] getArgs(Element element) {
        Element argElement = element.getElement("args");
        String[] args = new String[]{};
        if (argElement == null) {
            return args;
        }
        Elements elements = argElement.getElements();
        args = new String[elements.size()];
        int i = 0;
        while (elements.hasMoreElements()) {
            args[i] = elements.next().getString();
            ++i;
        }
        return args;
    }

    public Class getReturnType() throws ClassNotFoundException {
        try {
            return this.newInstance().getClass();
        }
        catch (ClassNotFoundException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throw new ClassNotFoundException(throwable.toString());
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }
}

