/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.server.sql;

import electric.sql.SQLClient;
import electric.sql.mapping.ITable;
import electric.uddi.Category;
import electric.uddi.Description;
import electric.uddi.Identifier;
import electric.uddi.Overview;
import electric.uddi.TModel;
import electric.uddi.TModelInstance;
import electric.uddi.server.sql.CategoryTable;
import electric.uddi.server.sql.DescriptionTable;
import electric.uddi.server.sql.IdentifierTable;
import electric.uddi.server.sql.OverviewTable;
import electric.util.array.ArrayUtil;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TModelTable
implements ITable {
    private SQLClient sqlClient;
    private DescriptionTable descriptionTable;
    private OverviewTable overviewTable;
    private IdentifierTable identifierTable;
    private CategoryTable categoryTable;

    public TModelTable(String databaseName) {
        this(new SQLClient(databaseName));
    }

    public TModelTable(SQLClient sqlClient) {
        this.sqlClient = sqlClient;
        this.initTables();
    }

    private void initTables() {
        this.descriptionTable = new DescriptionTable(this.sqlClient);
        this.overviewTable = new OverviewTable(this.sqlClient);
        this.identifierTable = new IdentifierTable(this.sqlClient);
        this.categoryTable = new CategoryTable(this.sqlClient);
    }

    public void insert(Object value) throws SQLException {
        TModel tModel = (TModel)value;
        String tModelKey = tModel.getTModelKey();
        String name = tModel.getName();
        String authorizedName = tModel.getAuthorizedName();
        String siteOperator = tModel.getOperator();
        String userName = tModel.getUserName();
        boolean checked = tModel.isChecked();
        Description[] descriptions = tModel.getDescriptions();
        Overview overview = tModel.getOverview();
        Identifier[] identifiers = tModel.getIdentifiers();
        Category[] categories = tModel.getCategories();
        String sql = "INSERT into TMODEL (TMODEL_KEY, NAME, AUTHORIZED_NAME, SITE_OPERATOR, CHECKED, USER_NAME) VALUES ('" + tModelKey + "','" + name + "','" + authorizedName + "','" + siteOperator + "','" + checked + "','" + userName + "')";
        this.sqlClient.insert(sql);
        this.descriptionTable.insert(descriptions, tModelKey);
        this.overviewTable.insert(overview, tModelKey);
        this.identifierTable.insert(identifiers, tModelKey, tModelKey);
        this.categoryTable.insert(categories, tModelKey, tModelKey);
    }

    void insert(TModelInstance[] tModelInstances, String bindingKey) throws SQLException {
        String[] inserts = new String[tModelInstances.length];
        int i = 0;
        while (i < tModelInstances.length) {
            String tModelKey = tModelInstances[i].getTModelKey();
            Description[] descriptions = tModelInstances[i].getDescriptions();
            Description[] instanceDescriptions = tModelInstances[i].getInstanceDescriptions();
            Overview instanceOverview = tModelInstances[i].getInstanceOverview();
            String instanceParms = tModelInstances[i].getInstanceParms();
            inserts[i] = "INSERT into TMODEL_INSTANCE (TMODEL_KEY, BINDING_KEY, PARAMS) VALUES ('" + tModelKey + "','" + bindingKey + "','" + instanceParms + "')";
            this.sqlClient.insert(inserts[i]);
            this.descriptionTable.insert(descriptions, tModelKey);
            this.descriptionTable.insert(instanceDescriptions, tModelKey);
            this.overviewTable.insert(instanceOverview, tModelKey);
            ++i;
        }
    }

    public Object select(Object key) throws SQLException {
        String tModelKey = (String)key;
        TModel tModel = null;
        String query = "SELECT NAME, AUTHORIZED_NAME, SITE_OPERATOR, CHECKED, USER_NAME from tmodel where TMODEL_KEY = '" + tModelKey + "'";
        ResultSet rs = this.sqlClient.select(query);
        if (rs.next()) {
            String name = rs.getString(1);
            String authorizedName = rs.getString(2);
            String siteOperator = rs.getString(3);
            boolean checked = new Boolean(rs.getString(4));
            String userName = rs.getString(5);
            Description[] descriptions = this.descriptionTable.select(tModelKey);
            Overview overview = this.overviewTable.select(tModelKey);
            Category[] categories = this.categoryTable.select(tModelKey);
            Identifier[] identifiers = this.identifierTable.select(tModelKey);
            tModel = new TModel(name);
            tModel.setUserName(userName);
            tModel.setTModelKey(tModelKey);
            tModel.setAuthorizedName(authorizedName);
            tModel.setOperator(siteOperator);
            tModel.setChecked(checked);
            tModel.setOverview(overview);
            tModel.setDescriptions(descriptions);
            tModel.setIdentifiers(identifiers);
            tModel.setCategories(categories);
        }
        return tModel;
    }

    TModelInstance[] selectTModels(String bindingKey) throws SQLException {
        TModelInstance[] tModelInstances = new TModelInstance[]{};
        String query = "SELECT TMODEL_KEY, PARAMS from TMODEL_INSTANCE where BINDING_KEY = '" + bindingKey + "'";
        ResultSet rs = this.sqlClient.select(query);
        while (rs.next()) {
            String tModelKey = rs.getString(1);
            String instanceParams = rs.getString(2);
            Description[] descriptions = this.descriptionTable.select(tModelKey);
            Description[] instanceDescriptions = this.descriptionTable.select(tModelKey);
            Overview instanceOverview = this.overviewTable.select(tModelKey);
            TModelInstance tModelInstance = new TModelInstance(tModelKey);
            tModelInstance.setInstanceParms(instanceParams);
            tModelInstance.setDescriptions(descriptions);
            tModelInstance.setInstanceDescriptions(instanceDescriptions);
            tModelInstance.setInstanceOverview(instanceOverview);
            tModelInstances = (TModelInstance[])ArrayUtil.addElement(tModelInstances, tModelInstance);
        }
        return tModelInstances;
    }

    public void delete(Object key) throws SQLException {
        String tModelKey = (String)key;
        String[] statements = new String[]{"DELETE from tmodel where TMODEL_KEY = '" + tModelKey + "'", "DELETE from description where DESCRIPTION_KEY = '" + tModelKey + "'", "DELETE from overview where TMODEL_KEY = '" + tModelKey + "'", "DELETE from identifier where IDENTIFIER_KEY = '" + tModelKey + "'", "DELETE from category where CATEGORY_KEY = '" + tModelKey + "'"};
        this.sqlClient.execute(statements);
    }

    void delete(TModelInstance[] tModelInstances) throws SQLException {
        int i = 0;
        while (i < tModelInstances.length) {
            String tModelKey = tModelInstances[i].getTModelKey();
            String[] stmts = new String[]{"DELETE from tmodel_instance where TMODEL_KEY = '" + tModelKey + "'", "DELETE from description where DESCRIPTION_KEY = '" + tModelKey + "'", "DELETE from overview where TMODEL_KEY = '" + tModelKey + "'"};
            this.sqlClient.execute(stmts);
            ++i;
        }
    }

    public void clear() throws SQLException {
        ResultSet rs = this.sqlClient.select("SELECT TMODEL_KEY from tmodel");
        while (rs.next()) {
            this.delete(rs.getString(1));
        }
    }
}

