/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.server;

import electric.uddi.IUDDIConstants;
import electric.uddi.UDDIException;
import electric.util.dictionary.transactional.TransactionalDictionary;
import java.util.Enumeration;

public final class UDDIDictionary
implements IUDDIConstants {
    private TransactionalDictionary dictionary;

    public UDDIDictionary(TransactionalDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public Object get(String key) throws UDDIException {
        Object value = null;
        try {
            value = this.dictionary.get(key);
        }
        catch (Throwable exception) {
            throw new UDDIException(exception.toString());
        }
        if (value == null) {
            throw new UDDIException(10210);
        }
        return value;
    }

    public void put(String key, Object object) throws UDDIException {
        try {
            this.dictionary.put(key, object);
        }
        catch (Throwable exception) {
            throw new UDDIException(exception.toString());
        }
    }

    public void remove(String key) throws UDDIException {
        try {
            this.dictionary.remove(key);
        }
        catch (Throwable exception) {
            throw new UDDIException(exception.toString());
        }
    }

    public Object peek(String key) {
        return this.dictionary.peek(key);
    }

    public int size() {
        return this.dictionary.size();
    }

    public Enumeration elements() {
        return this.dictionary.elements();
    }

    public Enumeration keys() {
        return this.dictionary.keys();
    }

    public void clear() {
        this.dictionary.clear();
    }
}

