/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.selectors;

import electric.uddi.IUDDIServer;
import electric.uddi.Name;
import electric.uddi.Qualifier;
import electric.uddi.selectors.ISelector;
import electric.util.named.INamed;

public class NameSelector
implements ISelector {
    private static final int REGULAR = 0;
    private static final int STARTS = 1;
    private static final int ENDS = 2;
    private static final int ALL = 3;
    private static final int CONTAINS = 4;
    private static final Qualifier DEFAULT_QUALIFIER = new Qualifier();
    private int mode;
    private String text;
    private String language;
    private Qualifier qualifier;

    public NameSelector(Name name, Qualifier qualifier) {
        this.qualifier = qualifier == null ? DEFAULT_QUALIFIER : qualifier;
        this.text = this.qualifier.getCaseSensitiveMatch() ? name.getText() : name.getText().toUpperCase();
        this.language = name.getLanguage();
        if (qualifier.getExactNameMatch()) {
            this.mode = 0;
        } else if (this.text.equals("%")) {
            this.mode = 3;
        } else if (this.text.startsWith("%") && this.text.endsWith("%")) {
            this.mode = 4;
            this.text = this.text.substring(1, this.text.length() - 1);
        } else if (this.text.startsWith("%")) {
            this.mode = 1;
            this.text = this.text.substring(1);
        } else if (this.text.endsWith("%")) {
            this.mode = 2;
            this.text = this.text.substring(0, this.text.length() - 1);
        } else {
            this.mode = 0;
        }
    }

    public boolean selects(IUDDIServer server, Object object) {
        String objectName = ((INamed)object).getName();
        if (!this.qualifier.getCaseSensitiveMatch()) {
            objectName = objectName.toUpperCase();
        }
        if (this.qualifier.getExactNameMatch()) {
            return this.exactMatch(objectName);
        }
        return this.startsWithMatch(objectName);
    }

    private boolean exactMatch(String objectName) {
        if (this.mode == 0) {
            return objectName.equals(this.text);
        }
        if (this.mode == 3) {
            return true;
        }
        if (this.mode == 4) {
            return objectName.indexOf(this.text) != -1;
        }
        if (this.mode == 2) {
            return objectName.startsWith(this.text);
        }
        return objectName.endsWith(this.text);
    }

    private boolean startsWithMatch(String objectName) {
        if (this.mode == 0 || this.mode == 2) {
            return objectName.startsWith(this.text);
        }
        if (this.mode == 3) {
            return true;
        }
        return objectName.indexOf(this.text) != -1;
    }
}

