/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Authorization;
import electric.uddi.Binding;
import electric.uddi.IInquiryCommand;
import electric.uddi.ISubscriptionFilter;
import electric.uddi.IUDDIServer;
import electric.uddi.Service;
import electric.uddi.Services;
import electric.uddi.UDDIException;
import electric.uddi.util.UDDIUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class GetServices
implements IInquiryCommand,
ISubscriptionFilter {
    private String[] serviceKeys;

    public GetServices() {
    }

    public GetServices(String[] serviceKeys) {
        this.serviceKeys = serviceKeys;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean needsAuthorization() {
        return false;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        Service[] results = new Service[this.serviceKeys.length];
        int i = 0;
        while (i < results.length) {
            results[i] = GetServices.getService(server, this.serviceKeys[i]);
            ++i;
        }
        return new Services(results);
    }

    public static Service getService(IUDDIServer server, String serviceKey) throws UDDIException {
        Service service = new Service(server.readService(serviceKey));
        String[] bindingKeys = server.getBindingKeysForService(serviceKey);
        Binding[] fullBindings = new Binding[bindingKeys.length];
        int i = 0;
        while (i < bindingKeys.length) {
            fullBindings[i] = server.readBinding(bindingKeys[i]);
            ++i;
        }
        service.setBindings(fullBindings);
        return service;
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("get_serviceDetail");
        int i = 0;
        while (i < this.serviceKeys.length) {
            query.writeString("serviceKey", this.serviceKeys[i]);
            ++i;
        }
    }

    public void read(IReader reader) throws IOException {
        this.serviceKeys = UDDIUtil.getTexts(reader, "serviceKey");
    }
}

