/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.util;

import electric.util.resourceloader.ResourceLoaders;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class KeyStoreUtil {
    public static KeyStore loadKeyStoreFile(String keyStoreFile, String keyStorePass, String keyStoreType) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        FileInputStream keystoreStream = new FileInputStream(keyStoreFile);
        return KeyStoreUtil.loadKeyStore(keystoreStream, keyStorePass, keyStoreType);
    }

    public static KeyStore loadKeyStoreResource(String keyStoreName, String keyStorePass, String keyStoreType) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        byte[] keyStoreBytes = ResourceLoaders.loadResource(keyStoreName);
        ByteArrayInputStream keystoreStream = new ByteArrayInputStream(keyStoreBytes);
        return KeyStoreUtil.loadKeyStore(keystoreStream, keyStorePass, keyStoreType);
    }

    private static KeyStore loadKeyStore(InputStream keyStoreStream, String keyStorePass, String keyStoreType) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (keyStoreType == null) {
            keyStoreType = "JKS";
        }
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(keyStoreStream, keyStorePass.toCharArray());
        return keyStore;
    }
}

