/*
 * Decompiled with CFR 0.152.
 */
package electric.net.socket.ssl;

import electric.glue.IGLUELoggingConstants;
import electric.net.socket.ISocketFactory;
import electric.net.socket.ssl.ISSLProvider;
import electric.net.socket.ssl.providers.installed.InstalledProvider;
import electric.util.array.ArrayUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;

public class SSLSocketFactory
implements ISocketFactory,
IGLUELoggingConstants {
    private static boolean serverSocketNeedsClientAuth;
    private static boolean clientSocketNeedsClientAuth;
    private static ISSLProvider sslProvider;
    private javax.net.ssl.SSLSocketFactory socketFactory = sslProvider.getSSLSocketFactory();
    private SSLServerSocketFactory serverSocketFactory = sslProvider.getSSLServerSocketFactory();
    private String[] clientCipherSuites = new String[0];
    private String[] serverCipherSuites = new String[0];

    public static void setSSLProvider(ISSLProvider sslProvider) {
        SSLSocketFactory.sslProvider = sslProvider;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoclose) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.socketFactory.createSocket(socket, host, port, autoclose);
        this.configureClientSocket(sslSocket);
        sslSocket.startHandshake();
        return sslSocket;
    }

    public Socket createSocket(InetAddress hostAddress, int port) throws IOException {
        SSLSocket socket = (SSLSocket)this.socketFactory.createSocket(hostAddress, port);
        this.configureClientSocket(socket);
        return socket;
    }

    public Socket createSocket(InetAddress local, int localPort, InetAddress remote, int remotePort) throws IOException {
        SSLSocket socket = (SSLSocket)this.socketFactory.createSocket(remote, remotePort, local, localPort);
        this.configureClientSocket(socket);
        return socket;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress address) throws IOException {
        SSLServerSocket serverSocket = address == null ? (SSLServerSocket)this.serverSocketFactory.createServerSocket(port, backlog) : (SSLServerSocket)this.serverSocketFactory.createServerSocket(port, backlog, address);
        if (serverSocketNeedsClientAuth) {
            serverSocket.setNeedClientAuth(true);
        }
        String[] cipherSuites = serverSocket.getEnabledCipherSuites();
        cipherSuites = (String[])ArrayUtil.addElements(cipherSuites, this.serverCipherSuites);
        serverSocket.setEnabledCipherSuites(cipherSuites);
        return serverSocket;
    }

    public String getProtocol() {
        return "ssl";
    }

    public void setServerSocketNeedsClientAuth(boolean serverSocketNeedsClientAuth) {
        SSLSocketFactory.serverSocketNeedsClientAuth = serverSocketNeedsClientAuth;
    }

    public void setClientSocketNeedsClientAuth(boolean clientSocketNeedsClientAuth) {
        SSLSocketFactory.clientSocketNeedsClientAuth = clientSocketNeedsClientAuth;
    }

    public void addClientCipherSuite(String suite) {
        this.clientCipherSuites = (String[])ArrayUtil.addElement(this.clientCipherSuites, suite);
    }

    public void addServerCipherSuite(String suite) {
        this.serverCipherSuites = (String[])ArrayUtil.addElement(this.serverCipherSuites, suite);
    }

    private void configureClientSocket(SSLSocket socket) {
        if (clientSocketNeedsClientAuth) {
            socket.setUseClientMode(false);
            socket.setNeedClientAuth(true);
        }
        String[] cipherSuites = socket.getEnabledCipherSuites();
        cipherSuites = (String[])ArrayUtil.addElements(cipherSuites, this.clientCipherSuites);
        socket.setEnabledCipherSuites(cipherSuites);
    }

    static {
        block2: {
            serverSocketNeedsClientAuth = false;
            clientSocketNeedsClientAuth = false;
            try {
                sslProvider = new InstalledProvider();
            }
            catch (Exception exception) {
                if (!Log.isLogging(ILoggingConstants.STARTUP_EVENT)) break block2;
                Log.log(ILoggingConstants.STARTUP_EVENT, "could not initialize SSLSocketFactory, ssl communication will not work.", exception);
            }
        }
    }
}

