/*
 * Decompiled with CFR 0.152.
 */
package electric.holder.tools;

import electric.holder.Holders;
import electric.jaxrpc.JAXHolderType;
import electric.util.array.ArrayUtil;
import electric.util.file.FileUtil;
import electric.util.string.Strings;
import java.io.File;
import java.io.IOException;

public class Holder {
    private static String[] classNames = new String[0];
    private static String dir = "";

    public static void main(String[] args) {
        if (args.length == 0) {
            Holder.printUsage();
            return;
        }
        try {
            Holder.processArgs(args);
            Holder.holder();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Holder.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: holder classname+ [-d directory] [-h] [-r]");
        System.out.println();
        System.out.println("where:");
        System.out.println("  classname    = name of java class (can end with [], [][], etc.)");
        System.out.println("  -h           = print help and exit");
        System.out.println("  -d directory = output directory, '.' by default");
        System.out.println("  -r           = generate JAX-RPC holders, false by default");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("holder -d \\electric\\src\\examples\\holders examples.holders.Foo");
        System.out.println("  create holders for examples.holders.Foo, place in specified directory");
        System.out.println();
        System.out.println("holder examples.holders.Foo[]");
        System.out.println("  create holders for array of examples.holders.Foo, place in current directory");
    }

    private static void processArgs(String[] args) throws Throwable {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                classNames = (String[])ArrayUtil.addElement(classNames, arg);
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'd': {
                        dir = Strings.getString("d", args, ++i);
                        if (dir.endsWith("/") || dir.endsWith("\\")) break;
                        dir = dir + File.separator;
                        break;
                    }
                    case 'h': {
                        Holder.printUsage();
                        System.exit(-1);
                    }
                    case 'r': {
                        Holders.setHolderType(new JAXHolderType());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
    }

    private static void holder() throws IOException {
        int i = 0;
        while (i < classNames.length) {
            Holder.writeHolder(classNames[i]);
            ++i;
        }
    }

    private static void writeHolder(String className) throws IOException {
        String inOutHolderClassName;
        String outHolderClassName = Holders.getOutHolderClassName(className);
        if (outHolderClassName != null) {
            String outFileName = Strings.getLocalJavaName(outHolderClassName);
            FileUtil.saveFile(dir, outFileName, Holders.getOutHolderJava(className), ".java");
        }
        if ((inOutHolderClassName = Holders.getInOutHolderClassName(className)) != null) {
            String inOutFileName = Strings.getLocalJavaName(inOutHolderClassName);
            FileUtil.saveFile(dir, inOutFileName, Holders.getInOutHolderJava(className), ".java");
        }
    }
}

