/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.endpoints;

import electric.fabric.IFabricConstants;
import electric.fabric.endpoints.EndpointManager;
import electric.fabric.endpoints.EndpointManagerException;
import electric.fabric.rules.Rule;
import electric.util.array.ArrayUtil;

public final class RuleRefresher
implements Runnable,
IFabricConstants {
    private static long ruleRefreshCycle = 20000L;
    private EndpointManager manager;
    private boolean stop = false;

    public RuleRefresher(EndpointManager manager) {
        this.manager = manager;
    }

    public static void setRuleRefreshCycle(long milliseconds) {
        ruleRefreshCycle = milliseconds;
    }

    public void run() {
        while (!this.stop) {
            try {
                this.updateRules();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(ruleRefreshCycle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stop() {
        this.stop = true;
    }

    private void updateRules() throws EndpointManagerException {
        String[] urls = this.manager.getLocalEndpointURLs();
        Rule[] allRules = this.manager.getRulesForEndpointWithURL("*");
        int i = 0;
        while (i < urls.length) {
            String url = urls[i];
            Rule[] rules = this.manager.getRulesForEndpointWithURL(url);
            rules = (Rule[])ArrayUtil.addElements(rules, allRules);
            this.manager.getEndpoint(url).setRules(rules);
            ++i;
        }
    }
}

