/*
 * Decompiled with CFR 0.152.
 */
package electric.console.services;

import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.ConsoleProductInfo;
import electric.console.services.IConsoleFacade;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.glue.IGLUELoggingConstants;
import electric.glue.context.ThreadContext;
import electric.util.UUID;
import electric.util.classloader.ClassLoaders;
import electric.util.http.HTTPUtil;
import electric.util.io.FastStringWriter;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.reflect.MethodLookup;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.NodeWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletResponse;

public class ConsoleFacade
implements IConsoleFacade,
IGLUELoggingConstants,
IConsoleConstants {
    private static Hashtable modules = new Hashtable();
    private static Hashtable products = new Hashtable();
    private static String masterProduct;
    static /* synthetic */ Class class$electric$console$services$IConsoleModule;

    public static void registerProduct(String productName, String treeLabel, String serviceClassName, String swfURL, String serviceURL, String helpFileURL) {
        ConsoleProductInfo productInfo = new ConsoleProductInfo(productName, treeLabel, serviceClassName, swfURL, serviceURL, helpFileURL);
        if (products.isEmpty()) {
            masterProduct = productName;
        }
        products.put(productName, productInfo);
    }

    public static void registerConsoleModule(String productName, String serviceId, String serviceClassName, String swfPath, String serviceURL, String helpfileURL) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class serviceClass = ClassLoaders.loadClass(serviceClassName);
        Object consoleModule = serviceClass.newInstance();
        if (!(consoleModule instanceof IConsoleModule)) {
            throw new IllegalArgumentException("console module must implement " + (class$electric$console$services$IConsoleModule == null ? (class$electric$console$services$IConsoleModule = ConsoleFacade.class$("electric.console.services.IConsoleModule")) : class$electric$console$services$IConsoleModule).getName());
        }
        ConsoleModuleInfo moduleInfo = new ConsoleModuleInfo(consoleModule, swfPath, serviceURL, helpfileURL);
        ((IConsoleModule)consoleModule).setConsoleModuleInfo(moduleInfo);
        serviceId = serviceId.toLowerCase();
        modules.put(serviceId, moduleInfo);
        ConsoleProductInfo productInfo = (ConsoleProductInfo)products.get(productName);
        productInfo.addServiceId(serviceId);
    }

    public Object getConsoleData(String serviceId, String methodName, String consoleArgs, String flag) throws Exception {
        if (Log.isLogging(IGLUELoggingConstants.CONSOLE_DEBUG_EVENT)) {
            Log.log(IGLUELoggingConstants.CONSOLE_DEBUG_EVENT, (Object)("request for " + serviceId + "\tflag " + flag + "\tmethod " + methodName + "\targs " + consoleArgs));
        }
        try {
            Object[] objectArray;
            Object service = this.getServiceObject(serviceId.toLowerCase());
            Method method = this.getMethod(service, methodName);
            Hashtable args = this.parseArgs(consoleArgs);
            this.disableResponseCache();
            if (args == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = args;
            }
            return method.invoke(service, objectArray);
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception while processing console's request", exception);
            }
            throw exception;
        }
    }

    public Object getConsoleData(String flashOnload, String flashCallback, String postArgs) throws Exception {
        String[][] query = null;
        query = HTTPUtil.getParametersAsArray(postArgs);
        String serviceId = this.getParameter("serviceId", query);
        String methodName = this.getParameter("methodName", query);
        String flag = this.getParameter("flag", query);
        String consoleArgs = this.getParameter("consoleArgs", query);
        if (Log.isLogging(IGLUELoggingConstants.CONSOLE_DEBUG_EVENT)) {
            Log.log(IGLUELoggingConstants.CONSOLE_DEBUG_EVENT, (Object)("request for " + serviceId + "\tflag " + flag + "\tmethod " + methodName + "\targs " + consoleArgs));
        }
        try {
            Object[] objectArray;
            Object service = this.getServiceObject(serviceId.toLowerCase());
            Method method = this.getMethod(service, methodName);
            Hashtable args = this.parseArgs(consoleArgs);
            this.disableResponseCache();
            if (args == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = args;
            }
            return method.invoke(service, objectArray);
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "exception while processing console's request", exception);
            }
            throw exception;
        }
    }

    private void disableResponseCache() {
        HttpServletResponse response = ThreadContext.getHttpResponse();
        if (response != null) {
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Expires", "-1");
        }
    }

    private Object getServiceObject(String serviceId) {
        ConsoleModuleInfo moduleInfo = (ConsoleModuleInfo)modules.get(serviceId);
        if (moduleInfo == null) {
            throw new IllegalArgumentException("invalid service id. service cannot be found");
        }
        return moduleInfo.getConsoleModuleObject();
    }

    public static ConsoleModuleInfo getConsoleModuleInfo(String moduleName) {
        return (ConsoleModuleInfo)modules.get(moduleName.toLowerCase());
    }

    private Method getMethod(Object service, String methodName) {
        Method[] methods = MethodLookup.getMethods(service.getClass(), methodName);
        if (methods.length > 1) {
            throw new IllegalArgumentException("overloaded methods not allowed in console services");
        }
        if (methods.length == 0) {
            throw new IllegalArgumentException("invalid method name. method cannot be found");
        }
        return methods[0];
    }

    private Hashtable parseArgs(String args) {
        StringTokenizer tokenizer = new StringTokenizer(args, ";=");
        Hashtable<String, String> parsedArgs = new Hashtable<String, String>();
        while (tokenizer.hasMoreElements()) {
            String arg = tokenizer.nextToken();
            String value = tokenizer.nextToken();
            parsedArgs.put(arg, value);
        }
        return parsedArgs.isEmpty() ? null : parsedArgs;
    }

    private String writeTreeDocument(Document treeView) {
        FastStringWriter stringWriter = new FastStringWriter(256);
        NodeWriter nodeWriter = new NodeWriter(stringWriter, 0, false, 0, "");
        try {
            treeView.write(nodeWriter);
            return stringWriter.toString();
        }
        catch (IOException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String getTreeView(String sessionId, String flag) {
        Element root;
        Document treeView = new Document();
        Element firstTree = root = treeView.setRoot("Root");
        if (sessionId.equals("")) {
            sessionId = new UUID().getKey();
            ConsoleProductInfo masterProductInfo = (ConsoleProductInfo)products.get(masterProduct);
            firstTree = root.addElement("Root");
            firstTree.setAttribute("Name", masterProductInfo.getTreeLabel());
            firstTree.setAttribute("Function", "showDetails");
            firstTree.setAttribute("TARGET", "_root");
            firstTree.setAttribute("swfURL", masterProductInfo.getswfURL());
            firstTree.setAttribute("helpfileURL", masterProductInfo.getHelpFileURL());
            firstTree.setAttribute("serviceURL", masterProductInfo.getServiceURL());
        }
        Enumeration keys = products.keys();
        while (keys.hasMoreElements()) {
            String productName = (String)keys.nextElement();
            ConsoleProductInfo productInfo = (ConsoleProductInfo)products.get(productName);
            String[] serviceIds = productInfo.getServiceIDs();
            Element subTreeRoot = firstTree;
            if (!productName.equals(masterProduct)) {
                Element panel = subTreeRoot.addElement(productInfo.getTreeLabel());
                panel.setAttribute("Name", productInfo.getTreeLabel());
                panel.setAttribute("Function", "showDetails");
                panel.setAttribute("TARGET", "_root");
                panel.setAttribute("swfURL", productInfo.getswfURL());
                panel.setAttribute("helpfileURL", productInfo.getHelpFileURL());
                panel.setAttribute("serviceURL", productInfo.getServiceURL());
                subTreeRoot = panel;
            }
            this.buildSubTree(serviceIds, subTreeRoot, sessionId, firstTree != root);
        }
        if (firstTree != root) {
            Element sessionElement = root.addElement("sessionId");
            sessionElement.setText(sessionId);
        }
        return this.writeTreeDocument(treeView);
    }

    private String getParameter(String key, String[][] theArray) {
        String newString = "";
        int i = 0;
        while (i < theArray.length) {
            if (theArray[i][0].equals(key)) {
                return theArray[i][1];
            }
            ++i;
        }
        return newString;
    }

    private void buildSubTree(String[] serviceIds, Element element, String sessionId, boolean isNewSession) {
        int i = 0;
        while (i < serviceIds.length) {
            Element[] newElement;
            Object serviceObj = this.getServiceObject(serviceIds[i]);
            if (serviceObj instanceof ITreeViewProducer && (((ITreeViewProducer)serviceObj).isSessionAware() || isNewSession) && (newElement = ((ITreeViewProducer)serviceObj).getConsoleTreeViewElement(sessionId)) != null) {
                int k = 0;
                while (k < newElement.length) {
                    element.addElement(newElement[k]);
                    ++k;
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

