/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper.attribute.user;

import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.util.DNStandardiser;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.ldap.core.DirContextAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberOfOverlayMapper
implements AttributeMapper {
    public static final String ATTRIBUTE_KEY = "memberOf";
    private final String userMemberOfAttribute;
    private final boolean relaxedDnStandardisation;

    public MemberOfOverlayMapper(String userMemberOfAttribute, boolean relaxedDnStandardisation) {
        this.userMemberOfAttribute = userMemberOfAttribute;
        this.relaxedDnStandardisation = relaxedDnStandardisation;
    }

    @Override
    public String getKey() {
        return ATTRIBUTE_KEY;
    }

    @Override
    public Set<String> getValues(DirContextAdapter ctx) throws Exception {
        String[] memberships = ctx.getStringAttributes(this.userMemberOfAttribute);
        if (memberships != null) {
            HashSet<String> standardDNs = new HashSet<String>(memberships.length);
            for (String memberDN : memberships) {
                String dn = DNStandardiser.standardise(memberDN, !this.relaxedDnStandardisation);
                standardDNs.add(dn);
            }
            return standardDNs;
        }
        return Collections.emptySet();
    }
}

