/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.hybrid;

import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.hybrid.InternalGroupHandler;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;

public class LocalGroupHandler
extends InternalGroupHandler {
    public LocalGroupHandler(InternalRemoteDirectory internalDirectory) {
        super(internalDirectory);
    }

    public Group findLocalGroup(String groupName) throws GroupNotFoundException, OperationFailedException {
        InternalDirectoryGroup group = this.getInternalDirectory().findGroupByName(groupName);
        if (group.isLocal()) {
            return group;
        }
        throw new GroupNotFoundException(groupName);
    }

    public Group createLocalGroup(GroupTemplate groupTemplate) throws InvalidGroupException, OperationFailedException, DirectoryNotFoundException {
        return this.getInternalDirectory().addLocalGroup(groupTemplate);
    }

    public Group updateLocalGroup(GroupTemplate groupTemplate) throws OperationFailedException, GroupNotFoundException, ReadOnlyGroupException, InvalidGroupException {
        this.findLocalGroup(groupTemplate.getName());
        return this.getInternalDirectory().updateGroup(groupTemplate);
    }

    public void addUserToLocalGroup(String username, String groupName) throws OperationFailedException, GroupNotFoundException, ReadOnlyGroupException, UserNotFoundException {
        this.findLocalGroup(groupName);
        this.getInternalDirectory().addUserToGroup(username, groupName);
    }

    public void addLocalGroupToLocalGroup(String childGroup, String parentGroup) throws OperationFailedException, InvalidMembershipException, GroupNotFoundException, ReadOnlyGroupException {
        this.findLocalGroup(childGroup);
        this.findLocalGroup(parentGroup);
        this.getInternalDirectory().addGroupToGroup(childGroup, parentGroup);
    }

    public void removeUserFromLocalGroup(String username, String groupName) throws OperationFailedException, GroupNotFoundException, MembershipNotFoundException, ReadOnlyGroupException, UserNotFoundException {
        this.findLocalGroup(groupName);
        this.getInternalDirectory().removeUserFromGroup(username, groupName);
    }

    public void removeLocalGroupFromLocalGroup(String childGroup, String parentGroup) throws OperationFailedException, InvalidMembershipException, GroupNotFoundException, MembershipNotFoundException, ReadOnlyGroupException {
        this.findLocalGroup(childGroup);
        this.findLocalGroup(parentGroup);
        this.getInternalDirectory().removeGroupFromGroup(childGroup, parentGroup);
    }
}

