/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.email;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmailTag
extends TagSupport {
    private Log logger = LogFactory.getLog((Class)(class$org$apache$commons$jelly$tags$email$EmailTag == null ? (class$org$apache$commons$jelly$tags$email$EmailTag = EmailTag.class$("org.apache.commons.jelly.tags.email.EmailTag")) : class$org$apache$commons$jelly$tags$email$EmailTag));
    private Expression server = null;
    private Expression from = null;
    private Expression to = null;
    private Expression cc = null;
    private Expression subject = null;
    private Expression message = null;
    private File attachment = null;
    private boolean encodeXML = false;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$email$EmailTag;

    public void setServer(Expression server) {
        this.server = server;
    }

    public void setFrom(Expression from) {
        this.from = from;
    }

    public void setTo(Expression to) {
        this.to = to;
    }

    public void setCC(Expression cc) {
        this.cc = cc;
    }

    public void setSubject(Expression subject) {
        this.subject = subject;
    }

    public void setMessage(Expression message) {
        this.message = message;
    }

    public void setAttach(File attachment) throws FileNotFoundException {
        if (!attachment.exists()) {
            throw new FileNotFoundException("attachment not found");
        }
        this.attachment = attachment;
    }

    public void setEncodeXML(boolean encodeXML) {
        this.encodeXML = encodeXML;
    }

    public void doTag(XMLOutput xmlOutput) throws JellyTagException {
        Properties props = new Properties();
        ((Hashtable)props).putAll(this.context.getVariables());
        if (this.server != null) {
            Object serverInput = this.server.evaluate(this.context);
            ((Hashtable)props).put("mail.smtp.host", serverInput.toString());
        } else if (((Hashtable)props).get("mail.smtp.host") == null) {
            throw new JellyTagException("no smtp server configured");
        }
        if (this.to == null) {
            throw new JellyTagException("no to address specified");
        }
        if (this.from == null) {
            throw new JellyTagException("no from address specified");
        }
        String messageBody = null;
        messageBody = this.message != null ? this.message.evaluate(this.context).toString() : this.getBodyText(this.encodeXML);
        Object fromInput = this.from.evaluate(this.context);
        Object toInput = this.to.evaluate(this.context);
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session);
        try {
            msg.setFrom((Address)new InternetAddress(fromInput.toString()));
            StringTokenizer st = new StringTokenizer(toInput.toString(), ";");
            InternetAddress[] addresses = new InternetAddress[st.countTokens()];
            int addressCount = 0;
            while (st.hasMoreTokens()) {
                addresses[addressCount++] = new InternetAddress(st.nextToken().trim());
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])addresses);
            if (this.cc != null) {
                Object ccInput = this.cc.evaluate(this.context);
                st = new StringTokenizer(ccInput.toString(), ";");
                InternetAddress[] ccAddresses = new InternetAddress[st.countTokens()];
                int ccAddressCount = 0;
                while (st.hasMoreTokens()) {
                    ccAddresses[ccAddressCount++] = new InternetAddress(st.nextToken().trim());
                }
                msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddresses);
            }
        }
        catch (AddressException e) {
            throw new JellyTagException((Throwable)e);
        }
        catch (MessagingException e) {
            throw new JellyTagException((Throwable)e);
        }
        try {
            if (this.subject != null) {
                Object subjectInput = this.subject.evaluate(this.context);
                msg.setSubject(subjectInput.toString());
            }
            msg.setSentDate(new Date());
            if (this.attachment == null) {
                msg.setText(messageBody);
            } else {
                MimeBodyPart mbp1 = new MimeBodyPart();
                mbp1.setText(messageBody);
                MimeBodyPart mbp2 = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(this.attachment);
                mbp2.setDataHandler(new DataHandler((DataSource)fds));
                mbp2.setFileName(fds.getName());
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)mbp1);
                mp.addBodyPart((BodyPart)mbp2);
                msg.setContent((Multipart)mp);
            }
            this.logger.info((Object)("sending email to " + this.to + " using " + this.server));
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            throw new JellyTagException((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

