/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.password.factory;

import com.atlassian.crowd.exception.PasswordEncoderException;
import com.atlassian.crowd.exception.PasswordEncoderNotFoundException;
import com.atlassian.crowd.password.encoder.InternalPasswordEncoder;
import com.atlassian.crowd.password.encoder.LdapPasswordEncoder;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordEncoderFactoryImpl
implements PasswordEncoderFactory {
    private Map<String, PasswordEncoder> internalEncoders = new HashMap<String, PasswordEncoder>();
    private Map<String, PasswordEncoder> ldapEncoders = new HashMap<String, PasswordEncoder>();
    private Set<String> supportedInternalEncoders = null;
    private Set<String> supportedLdapEncoders = null;
    private static final Logger LOGGER = Logger.getLogger(PasswordEncoderFactoryImpl.class);

    public void setEncoders(List<PasswordEncoder> encoders) {
        for (PasswordEncoder encoder : encoders) {
            this.addEncoder(encoder);
        }
    }

    @Override
    public PasswordEncoder getInternalEncoder(String encoder) {
        PasswordEncoder passwordEncoder = this.internalEncoders.get(encoder);
        if (passwordEncoder == null) {
            throw new PasswordEncoderNotFoundException("The PasswordEncoder '" + encoder + "' was not found in the Internal Encoders list by the PasswordEncoderFactory");
        }
        return passwordEncoder;
    }

    @Override
    public PasswordEncoder getLdapEncoder(String encoder) {
        PasswordEncoder passwordEncoder = this.ldapEncoders.get(encoder);
        if (passwordEncoder == null) {
            throw new PasswordEncoderNotFoundException("The PasswordEncoder '" + encoder + "' was not found in the LDAP Encoders list by the PasswordEncoderFactory");
        }
        return passwordEncoder;
    }

    @Override
    public PasswordEncoder getEncoder(String encoder) throws PasswordEncoderNotFoundException {
        PasswordEncoder passwordEncoder = this.ldapEncoders.get(encoder);
        if (passwordEncoder == null) {
            passwordEncoder = this.internalEncoders.get(encoder);
        }
        if (passwordEncoder == null) {
            throw new PasswordEncoderNotFoundException("The PasswordEncoder '" + encoder + "' was not found in the encoders list by the PasswordEncoderFactory");
        }
        return passwordEncoder;
    }

    @Override
    public Set<String> getSupportedInternalEncoders() {
        if (this.supportedInternalEncoders == null) {
            this.supportedInternalEncoders = Collections.unmodifiableSet(new TreeSet<String>(this.internalEncoders.keySet()));
        }
        return this.supportedInternalEncoders;
    }

    @Override
    public Set<String> getSupportedLdapEncoders() {
        if (this.supportedLdapEncoders == null) {
            this.supportedLdapEncoders = Collections.unmodifiableSet(new TreeSet<String>(this.ldapEncoders.keySet()));
        }
        return this.supportedLdapEncoders;
    }

    @Override
    public void addEncoder(PasswordEncoder passwordEncoder) throws PasswordEncoderException {
        if (passwordEncoder == null) {
            throw new PasswordEncoderException("You cannot add a null password encoder to the factory");
        }
        if (passwordEncoder.getKey() == null) {
            throw new PasswordEncoderException("Your password encoder must contain a 'key' value");
        }
        if (passwordEncoder instanceof LdapPasswordEncoder) {
            LOGGER.debug((Object)("Adding LDAP Password Encoder to Factory: " + passwordEncoder.getKey()));
            this.ldapEncoders.put(passwordEncoder.getKey().toLowerCase(Locale.ENGLISH), passwordEncoder);
        }
        if (passwordEncoder instanceof InternalPasswordEncoder) {
            LOGGER.debug((Object)("Adding Internal Password Encoder to Factory: " + passwordEncoder.getKey()));
            this.internalEncoders.put(passwordEncoder.getKey().toLowerCase(Locale.ENGLISH), passwordEncoder);
        }
        try {
            this.getEncoder(passwordEncoder.getKey());
        }
        catch (PasswordEncoderNotFoundException e) {
            throw new PasswordEncoderException("Your password encoder does not support a valid encoder type.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEncoder(PasswordEncoder passwordEncoder) {
        PasswordEncoderFactoryImpl passwordEncoderFactoryImpl = this;
        synchronized (passwordEncoderFactoryImpl) {
            this.internalEncoders.remove(passwordEncoder.getKey().toLowerCase(Locale.ENGLISH));
            this.ldapEncoders.remove(passwordEncoder.getKey().toLowerCase(Locale.ENGLISH));
        }
    }
}

