/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util.thumbnail;

import com.atlassian.core.util.ImageInfo;
import com.atlassian.core.util.thumbnail.SimpleImageConsumer;
import com.atlassian.core.util.thumbnail.Thumbnail;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Thumber {
    private static final Logger log = Logger.getLogger(Thumber.class);
    private final ImageInfo imageInfo = new ImageInfo();
    public static final List<String> THUMBNAIL_MIME_TYPES = Collections.unmodifiableList(Arrays.asList(ImageIO.getReaderMIMETypes()));
    public static final List<String> THUMBNAIL_FORMATS = Collections.unmodifiableList(Arrays.asList(ImageIO.getReaderFormatNames()));
    private Thumbnail.MimeType mimeType;
    private float encodingQuality = 0.8f;

    public Thumber() {
        this(Thumbnail.MimeType.JPG);
    }

    public Thumber(Thumbnail.MimeType mimeType) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        this.mimeType = mimeType;
    }

    public static List<String> getThumbnailMimeTypes() {
        return THUMBNAIL_MIME_TYPES;
    }

    public static List<String> getThumbnailFormats() {
        return THUMBNAIL_FORMATS;
    }

    public boolean checkToolkit() {
        try {
            Toolkit.getDefaultToolkit();
        }
        catch (Throwable e) {
            log.error((Object)"Unable to acquire AWT default toolkit - thumbnails will not be displayed. Check DISPLAY variable or use setting -Djava.awt.headless=true.", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Thumbnail retrieveOrCreateThumbNail(File originalFile, File thumbnailFile, int maxWidth, int maxHeight, long thumbnailId) throws MalformedURLException {
        Thumbnail thumbnail;
        FileInputStream originalFileStream = null;
        try {
            originalFileStream = new FileInputStream(originalFile);
            thumbnail = this.retrieveOrCreateThumbNail(originalFileStream, originalFile.getName(), thumbnailFile, maxWidth, maxHeight, thumbnailId);
        }
        catch (FileNotFoundException e) {
            try {
                log.error((Object)("Unable to create thumbnail: file not found: " + originalFile.getAbsolutePath()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(originalFileStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)originalFileStream);
            return null;
        }
        IOUtils.closeQuietly((InputStream)originalFileStream);
        return thumbnail;
    }

    private void storeImageAsPng(BufferedImage image, File file) throws FileNotFoundException {
        if (image == null) {
            log.warn((Object)"Can't store a null scaledImage.");
            return;
        }
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            log.error((Object)"Error encoding the thumbnail image", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeImage(BufferedImage scaledImage, File file) throws FileNotFoundException {
        if (scaledImage == null) {
            log.warn((Object)"Can't store a null scaledImage.");
            return;
        }
        FileImageOutputStream fout = null;
        try {
            fout = new FileImageOutputStream(file);
            ImageWriter writer = ImageIO.getImageWritersByFormatName("jpeg").next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(this.encodingQuality);
            writer.setOutput(fout);
            writer.write(null, new IIOImage(scaledImage, null, null), param);
        }
        catch (IOException e) {
            log.error((Object)"Error encoding the thumbnail image", (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private BufferedImage scaleImageFastAndGood(BufferedImage imageToScale, WidthHeightHelper newDimensions) {
        if (newDimensions.width > imageToScale.getWidth() || newDimensions.height > imageToScale.getHeight()) {
            return this.getScaledInstance(imageToScale, newDimensions.getWidth(), newDimensions.getHeight(), RenderingHints.VALUE_INTERPOLATION_BICUBIC, false);
        }
        return this.getScaledInstance(imageToScale, newDimensions.getWidth(), newDimensions.getHeight(), RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
    }

    private BufferedImage getScaledInstance(BufferedImage image, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type;
        int n = type = image.getTransparency() == 1 ? 1 : 2;
        if (higherQuality) {
            w = image.getWidth();
            h = image.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setComposite(AlphaComposite.SrcOver);
            g2.drawImage(image, 0, 0, w, h, null);
            g2.dispose();
            image = tmp;
        } while (w != targetWidth || h != targetHeight);
        return image;
    }

    public BufferedImage scaleImage(Image imageToScale, WidthHeightHelper newDimensions) {
        if (imageToScale instanceof BufferedImage) {
            return this.scaleImageFastAndGood((BufferedImage)imageToScale, newDimensions);
        }
        return this.scaleImageFastAndGood(Pictures.toBufferedImage(imageToScale), newDimensions);
    }

    @Deprecated
    public BufferedImage scaleImageOld(Image imageToScale, WidthHeightHelper newDimensions) {
        BufferedImage bufferedImage;
        if (imageToScale instanceof BufferedImage && !(bufferedImage = (BufferedImage)imageToScale).getColorModel().getColorSpace().isCS_sRGB()) {
            BufferedImage sRGBImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
            Graphics g = sRGBImage.getGraphics();
            g.drawImage(bufferedImage, 0, 0, null);
            g.dispose();
            imageToScale = sRGBImage;
        }
        AreaAveragingScaleFilter scaleFilter = new AreaAveragingScaleFilter(newDimensions.getWidth(), newDimensions.getHeight());
        FilteredImageSource producer = new FilteredImageSource(imageToScale.getSource(), scaleFilter);
        SimpleImageConsumer generator = new SimpleImageConsumer();
        producer.startProduction(generator);
        BufferedImage scaled = generator.getImage();
        if (scaled == null) {
            log.warn((Object)"Unabled to create scaled image.");
        } else {
            scaled.flush();
        }
        return scaled;
    }

    public Thumbnail retrieveOrCreateThumbNail(InputStream originalFileStream, String fileName, File thumbnailFile, int maxWidth, int maxHeight, long thumbnailId) throws MalformedURLException {
        Thumbnail thumbnail = null;
        try {
            thumbnail = this.getThumbnail(thumbnailFile, fileName, thumbnailId);
        }
        catch (IOException e) {
            log.error((Object)("Unable to get thumbnail image for id " + thumbnailId), (Throwable)e);
            return null;
        }
        if (thumbnail == null) {
            try {
                thumbnail = this.createThumbnail(originalFileStream, thumbnailFile, maxWidth, maxHeight, thumbnailId, fileName);
            }
            catch (IIOException e) {
                log.info((Object)("Unable to create thumbnail image for id " + thumbnailId), (Throwable)e);
                return null;
            }
            catch (IOException e) {
                log.error((Object)("Unable to create thumbnail image for id " + thumbnailId), (Throwable)e);
                return null;
            }
        }
        return thumbnail;
    }

    private BufferedImage scaleImage(Image originalImage, int maxWidth, int maxHeight) {
        return this.scaleImage(originalImage, this.determineScaleSize(maxWidth, maxHeight, originalImage));
    }

    private WidthHeightHelper determineScaleSize(int maxWidth, int maxHeight, Image image) {
        return this.determineScaleSize(maxWidth, maxHeight, image.getWidth(null), image.getHeight(null));
    }

    private Thumbnail createThumbnail(InputStream originalFile, File thumbnailFile, int maxWidth, int maxHeight, long thumbId, String fileName) throws IOException, FileNotFoundException {
        Image originalImage = this.getImage(originalFile);
        BufferedImage scaledImage = this.scaleImage(originalImage, maxWidth, maxHeight);
        int height = scaledImage.getHeight();
        int width = scaledImage.getWidth();
        if (this.mimeType == Thumbnail.MimeType.PNG) {
            this.storeImageAsPng(scaledImage, thumbnailFile);
        } else {
            this.storeImage(scaledImage, thumbnailFile);
        }
        return new Thumbnail(height, width, fileName, thumbId, this.mimeType);
    }

    private Thumbnail getThumbnail(File thumbnailFile, String filename, long thumbId) throws IOException {
        if (thumbnailFile.exists()) {
            Image thumbImage = this.getImage(thumbnailFile);
            return new Thumbnail(thumbImage.getHeight(null), thumbImage.getWidth(null), filename, thumbId, this.mimeType);
        }
        return null;
    }

    public Image getImage(File file) throws IOException {
        return ImageIO.read(file);
    }

    public Image getImage(InputStream is) throws IOException {
        return ImageIO.read(is);
    }

    public void setEncodingQuality(float f) {
        if (f > 1.0f || f < 0.0f) {
            throw new IllegalArgumentException("Invalid quality setting '" + f + "', value must be between 0 and 1. ");
        }
        this.encodingQuality = f;
    }

    public WidthHeightHelper determineScaleSize(int maxWidth, int maxHeight, int imageWidth, int imageHeight) {
        if (maxHeight > imageHeight && maxWidth > imageWidth) {
            return new WidthHeightHelper(imageWidth, imageHeight);
        }
        double thumbRatio = (double)maxWidth / (double)maxHeight;
        double imageRatio = (double)imageWidth / (double)imageHeight;
        if (thumbRatio < imageRatio) {
            return new WidthHeightHelper(maxWidth, (int)Math.max(1.0, (double)maxWidth / imageRatio));
        }
        return new WidthHeightHelper((int)Math.max(1.0, (double)maxHeight * imageRatio), maxHeight);
    }

    public boolean isFileSupportedImage(File file) {
        try {
            return this.isFileSupportedImage(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileSupportedImage(InputStream inputStream) {
        try {
            this.imageInfo.setInput(inputStream);
            this.imageInfo.check();
            for (String format : THUMBNAIL_FORMATS) {
                if (!format.equalsIgnoreCase(this.imageInfo.getFormatName())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    static class Pictures {
        Pictures() {
        }

        public static BufferedImage toBufferedImage(Image image) {
            if (image instanceof BufferedImage) {
                return (BufferedImage)image;
            }
            boolean hasAlpha = Pictures.hasAlpha(image = new ImageIcon(image).getImage());
            int type = hasAlpha ? 2 : 1;
            BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
            Graphics2D g = bimage.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            return bimage;
        }

        public static boolean hasAlpha(Image image) {
            if (image instanceof BufferedImage) {
                return ((BufferedImage)image).getColorModel().hasAlpha();
            }
            PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return pg.getColorModel().hasAlpha();
        }
    }

    public static class WidthHeightHelper {
        private int width;
        private int height;

        public WidthHeightHelper(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }
    }
}

