/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.auth.trustedapps.filter;

import com.atlassian.security.auth.trustedapps.ApplicationCertificate;
import com.atlassian.security.auth.trustedapps.DefaultEncryptedCertificate;
import com.atlassian.security.auth.trustedapps.InvalidCertificateException;
import com.atlassian.security.auth.trustedapps.TransportErrorMessage;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.atlassian.security.auth.trustedapps.UserResolver;
import com.atlassian.security.auth.trustedapps.filter.AuthenticationController;
import com.atlassian.security.auth.trustedapps.filter.Authenticator;
import com.atlassian.security.auth.trustedapps.filter.RequestSignatureTool;
import java.security.Principal;
import java.security.PublicKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedApplicationFilterAuthenticator
implements Authenticator {
    private static final Logger log = LoggerFactory.getLogger(TrustedApplicationFilterAuthenticator.class);
    final TrustedApplicationsManager appManager;
    final UserResolver resolver;
    final AuthenticationController authenticationController;

    public TrustedApplicationFilterAuthenticator(TrustedApplicationsManager appManager, UserResolver resolver, AuthenticationController authenticationController) {
        this.appManager = appManager;
        this.resolver = resolver;
        this.authenticationController = authenticationController;
    }

    private static boolean atLeast(Integer protocolVersion, int required) {
        return protocolVersion != null && protocolVersion >= required;
    }

    public Authenticator.Result authenticate(HttpServletRequest request, HttpServletResponse response) {
        Authenticator.Result.Failure result;
        Principal user;
        String signedRequestUrl;
        ApplicationCertificate certificate;
        Integer protocolVersion;
        String certStr = request.getHeader("X-Seraph-Trusted-App-Cert");
        if (TrustedApplicationFilterAuthenticator.isBlank(certStr)) {
            return new Authenticator.Result.NoAttempt();
        }
        String id = request.getHeader("X-Seraph-Trusted-App-ID");
        if (TrustedApplicationFilterAuthenticator.isBlank(id)) {
            Authenticator.Result.Error result2 = new Authenticator.Result.Error(new TransportErrorMessage.ApplicationIdNotFoundInRequest());
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result2.getMessage());
            return result2;
        }
        String key = request.getHeader("X-Seraph-Trusted-App-Key");
        if (TrustedApplicationFilterAuthenticator.isBlank(key)) {
            Authenticator.Result.Error result3 = new Authenticator.Result.Error(new TransportErrorMessage.SecretKeyNotFoundInRequest());
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result3.getMessage());
            return result3;
        }
        String magicNumber = request.getHeader("X-Seraph-Trusted-App-Magic");
        String version = request.getHeader("X-Seraph-Trusted-App-Version");
        try {
            protocolVersion = !TrustedApplicationFilterAuthenticator.isBlank(version) ? Integer.valueOf(Integer.parseInt(version)) : null;
        }
        catch (NumberFormatException e) {
            Authenticator.Result.Error result4 = new Authenticator.Result.Error(new TransportErrorMessage.BadProtocolVersion(version));
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result4.getMessage());
            return result4;
        }
        if (TrustedApplicationFilterAuthenticator.atLeast(protocolVersion, 1) && TrustedApplicationFilterAuthenticator.isBlank(magicNumber)) {
            Authenticator.Result.Error result5 = new Authenticator.Result.Error(new TransportErrorMessage.MagicNumberNotFoundInRequest());
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result5.getMessage());
            return result5;
        }
        TrustedApplication app = this.appManager.getTrustedApplication(id);
        if (app == null) {
            Authenticator.Result.Failure result6 = new Authenticator.Result.Failure(new TransportErrorMessage.ApplicationUnknown(id));
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result6.getMessage());
            return result6;
        }
        try {
            certificate = app.decode(new DefaultEncryptedCertificate(id, key, certStr, protocolVersion, magicNumber), request);
        }
        catch (InvalidCertificateException ex) {
            log.warn("Failed to login trusted application: " + app.getID() + " due to: " + ex);
            log.debug("Failed to login trusted application cause", (Throwable)ex);
            Authenticator.Result.Error result7 = new Authenticator.Result.Error(ex.getTransportErrorMessage());
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result7.getMessage());
            return result7;
        }
        String signature = request.getHeader("X-Seraph-Trusted-App-Signature");
        if (TrustedApplicationFilterAuthenticator.atLeast(protocolVersion, 2) && signature == null) {
            Authenticator.Result.Error result8 = new Authenticator.Result.Error(new TransportErrorMessage.BadSignature());
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result8.getMessage());
            return result8;
        }
        if (signature != null) {
            StringBuffer sb = request.getRequestURL();
            String q = request.getQueryString();
            if (q != null) {
                sb.append('?');
                sb.append(q);
            }
            String expectedSignedUrl = sb.toString();
            try {
                PublicKey publicKey = app.getPublicKey();
                if (!new RequestSignatureTool().verify(certificate.getCreationTime().getTime(), expectedSignedUrl, publicKey, signature)) {
                    log.warn("Failed to login trusted application: " + app.getID() + " due to bad URL signature.");
                    Authenticator.Result.Error result9 = new Authenticator.Result.Error(new TransportErrorMessage.BadSignature(expectedSignedUrl));
                    TrustedApplicationFilterAuthenticator.setFailureHeader(response, result9.getMessage());
                    return result9;
                }
                signedRequestUrl = expectedSignedUrl;
            }
            catch (RequestSignatureTool.UnableToVerifySignatureException e) {
                log.warn("Failed to login trusted application: " + app.getID() + " due to: " + e);
                Authenticator.Result.Error result10 = new Authenticator.Result.Error(new TransportErrorMessage.BadSignature(expectedSignedUrl));
                TrustedApplicationFilterAuthenticator.setFailureHeader(response, result10.getMessage());
                return result10;
            }
        } else {
            signedRequestUrl = null;
        }
        if ((user = this.resolver.resolve(certificate)) == null) {
            log.warn("User '" + certificate.getUserName() + "' referenced by trusted application: '" + app.getID() + "' is not found.");
            result = new Authenticator.Result.Failure(new TransportErrorMessage.UserUnknown(certificate.getUserName()));
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result.getMessage());
            return result;
        }
        if (!this.authenticationController.canLogin(user, request)) {
            log.warn("User '" + certificate.getUserName() + "' referenced by trusted application: '" + app.getID() + "' cannot login.");
            result = new Authenticator.Result.Failure(new TransportErrorMessage.PermissionDenied());
            TrustedApplicationFilterAuthenticator.setFailureHeader(response, result.getMessage());
            return result;
        }
        if (signedRequestUrl != null) {
            return new Authenticator.Result.Success(user, signedRequestUrl);
        }
        return new Authenticator.Result.Success(user);
    }

    private static void setFailureHeader(HttpServletResponse response, String message) {
        response.setHeader("X-Seraph-Trusted-App-Status", "ERROR");
        response.addHeader("X-Seraph-Trusted-App-Error", message);
        if (log.isDebugEnabled()) {
            log.debug(message, (Throwable)new RuntimeException(message));
        }
    }

    private static boolean isBlank(String input) {
        return input == null || input.trim().length() == 0;
    }
}

