/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.auth.trustedapps;

import com.atlassian.security.auth.trustedapps.ApplicationCertificate;
import com.atlassian.security.auth.trustedapps.BouncyCastleEncryptionProvider;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.DefaultTrustedApplication;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import com.atlassian.security.auth.trustedapps.InvalidCertificateException;
import com.atlassian.security.auth.trustedapps.Null;
import com.atlassian.security.auth.trustedapps.RequestConditions;
import com.atlassian.security.auth.trustedapps.TrustedApplication;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.servlet.http.HttpServletRequest;

public class DefaultCurrentApplication
implements CurrentApplication,
TrustedApplication {
    private static final int LOCAL_TIMEOUT = 1000;
    private final EncryptionProvider encryptionProvider;
    protected final String id;
    protected final PublicKey publicKey;
    protected final PrivateKey privateKey;

    public DefaultCurrentApplication(EncryptionProvider encryptionProvider, PublicKey publicKey, PrivateKey privateKey, String id) {
        Null.not("encryptionProvider", encryptionProvider);
        Null.not("publicKey", publicKey);
        Null.not("privateKey", privateKey);
        Null.not("id", id);
        this.encryptionProvider = encryptionProvider;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.id = id;
    }

    public DefaultCurrentApplication(PublicKey publicKey, PrivateKey privateKey, String id) {
        this(new BouncyCastleEncryptionProvider(), publicKey, privateKey, id);
    }

    public EncryptedCertificate encode(String userName) {
        return this.encode(userName, null);
    }

    public EncryptedCertificate encode(String userName, String urlToSign) {
        return this.encryptionProvider.createEncryptedCertificate(userName, this.privateKey, this.getID(), urlToSign);
    }

    public ApplicationCertificate decode(EncryptedCertificate encCert, HttpServletRequest request) throws InvalidCertificateException {
        ApplicationCertificate certificate = this.encryptionProvider.decodeEncryptedCertificate(encCert, this.publicKey, this.getID());
        DefaultTrustedApplication.checkCertificateExpiry(certificate, 1000L);
        return certificate;
    }

    public String getID() {
        return this.id;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public RequestConditions getRequestConditions() {
        return null;
    }

    public String getName() {
        return null;
    }
}

