/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.ofbiz;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PrimitiveMap {
    private static final Locale LOCALE = Locale.getDefault();

    static Builder builder() {
        return new Builder();
    }

    static Map<String, Object> of(String key, long value) {
        return PrimitiveMap.builder().put(key, value).build();
    }

    static Map<String, Object> of(String key, String value) {
        return PrimitiveMap.builder().put(key, value).build();
    }

    static Map<String, Object> of(String key1, long value1, String key2, String value2) {
        return PrimitiveMap.builder().put(key1, value1).put(key2, value2).build();
    }

    public static Map<String, Object> of(String key1, long value1, String key2, long value2) {
        return PrimitiveMap.builder().put(key1, value1).put(key2, value2).build();
    }

    static Map<String, Object> caseInsensitive(String key, String value) {
        return PrimitiveMap.builder().putCaseInsensitive(key, value).build();
    }

    private static String emptyForNull(String input) {
        return input == null ? "" : input;
    }

    private static String toLowerCase(String s) {
        return s != null ? s.toLowerCase(LOCALE) : null;
    }

    private PrimitiveMap() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Builder {
        final Map<String, Object> map = new HashMap<String, Object>();

        Builder() {
        }

        public Builder put(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        public Builder putCaseInsensitive(String key, String value) {
            this.map.put(key, PrimitiveMap.toLowerCase(value));
            return this;
        }

        public Builder putEmptyForNull(String key, String value) {
            this.map.put(key, PrimitiveMap.emptyForNull(value));
            return this;
        }

        public Builder put(String key, Long value) {
            this.map.put(key, value);
            return this;
        }

        public Builder put(String key, boolean value) {
            this.map.put(key, BooleanUtils.toInteger((boolean)value));
            return this;
        }

        public Builder put(String key, Date date) {
            this.map.put(key, new Timestamp(date.getTime()));
            return this;
        }

        public Map<String, Object> build() {
            return Collections.unmodifiableMap(this.map);
        }
    }
}

