/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.crowd.embedded.ofbiz.db.OfBizHelper;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.ofbiz.core.entity.GenericValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DirectoryEntity {
    static final String ENTITY = "Directory";
    static final String DIRECTORY_ID = "id";
    static final String NAME = "directoryName";
    static final String LOWER_NAME = "lowerDirectoryName";
    static final String ACTIVE = "active";
    static final String DESCRIPTION = "description";
    static final String CREATED_DATE = "createdDate";
    static final String UPDATED_DATE = "updatedDate";
    static final String TYPE = "type";
    static final String IMPLEMENTATION = "implementationClass";
    static final String LOWER_IMPLEMENTATION = "lowerImplementationClass";

    private DirectoryEntity() {
    }

    static Map<String, Object> getData(Directory directory) {
        PrimitiveMap.Builder data = PrimitiveMap.builder();
        data.put(NAME, directory.getName());
        data.putCaseInsensitive(LOWER_NAME, directory.getName());
        data.put(ACTIVE, directory.isActive());
        data.put(DESCRIPTION, directory.getDescription());
        data.put(TYPE, directory.getType().name());
        data.put(CREATED_DATE, OfBizHelper.convertToSqlTimestamp(directory.getCreatedDate()));
        data.put(UPDATED_DATE, OfBizHelper.convertToSqlTimestamp(directory.getUpdatedDate()));
        data.put(IMPLEMENTATION, directory.getImplementationClass());
        data.putCaseInsensitive(LOWER_IMPLEMENTATION, directory.getImplementationClass());
        return data.build();
    }

    static GenericValue setData(Directory directory, GenericValue gv) {
        gv.set(ACTIVE, (Object)BooleanUtils.toInteger((boolean)directory.isActive()));
        gv.set(CREATED_DATE, (Object)OfBizHelper.convertToSqlTimestamp(directory.getCreatedDate()));
        gv.set(UPDATED_DATE, (Object)OfBizHelper.convertToSqlTimestamp(directory.getUpdatedDate()));
        gv.set(DESCRIPTION, (Object)directory.getDescription());
        gv.set(NAME, (Object)directory.getName());
        gv.set(LOWER_NAME, (Object)directory.getName().toLowerCase());
        gv.set(IMPLEMENTATION, (Object)directory.getImplementationClass());
        gv.set(LOWER_IMPLEMENTATION, (Object)directory.getImplementationClass().toLowerCase());
        gv.set(TYPE, (Object)directory.getType().name());
        return gv;
    }
}

