/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.util;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.rpc.soap.beans.RemoteGroup;
import com.atlassian.jira.rpc.soap.beans.RemoteUser;
import com.atlassian.jira.rpc.soap.util.RemoteEntityFactory;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;

public class RemoteEntityFactoryImpl
implements RemoteEntityFactory {
    private final EmailFormatter emailFormatter;
    private final GroupManager groupManager;

    public RemoteEntityFactoryImpl(EmailFormatter emailFormatter, GroupManager groupManager) {
        this.emailFormatter = emailFormatter;
        this.groupManager = groupManager;
    }

    public RemoteUser createUser(User user) {
        Assertions.notNull((String)"user", (Object)user);
        RemoteUser remoteUser = new RemoteUser(user);
        remoteUser.setEmail(this.emailFormatter.formatEmail(user.getEmailAddress(), true));
        return remoteUser;
    }

    public RemoteGroup createGroup(Group group) {
        Assertions.notNull((String)"group", (Object)group);
        RemoteGroup remoteGroup = new RemoteGroup();
        remoteGroup.setName(group.getName());
        Collection usersInGroup = this.groupManager.getUsersInGroup(group.getName());
        RemoteUser[] remoteUsers = new RemoteUser[usersInGroup.size()];
        int i = 0;
        for (User user : usersInGroup) {
            remoteUsers[i] = this.createUser(user);
            ++i;
        }
        remoteGroup.setUsers(remoteUsers);
        return remoteGroup;
    }
}

