/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.service;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParamsImpl;
import com.atlassian.jira.plugin.searchrequestview.auth.Authorizer;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rpc.exception.RemoteException;
import com.atlassian.jira.rpc.exception.RemoteValidationException;
import com.atlassian.jira.rpc.soap.beans.RemoteIssue;
import com.atlassian.jira.rpc.soap.service.IssueRetriever;
import com.atlassian.jira.rpc.soap.service.SearchService;
import com.atlassian.jira.rpc.soap.util.SoapUtilsBean;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchServiceImpl
implements SearchService {
    private final SearchProvider searchProvider;
    private final SearchRequestService searchRequestService;
    private final CustomFieldManager customFieldManager;
    private final SoapUtilsBean soapUtilsBean;
    private final ProjectManager projectManager;
    private final AttachmentManager attachmentManager;
    private final Authorizer requestAuthorizer;
    private final com.atlassian.jira.bc.issue.search.SearchService theRealSearchService;
    private final IssueRetriever issueRetriever;

    public SearchServiceImpl(SearchProvider searchProvider, SearchRequestService searchRequestService, CustomFieldManager customFieldManager, SoapUtilsBean soapUtilsBean, ProjectManager projectManager, AttachmentManager attachmentManager, Authorizer requestAuthorizer, com.atlassian.jira.bc.issue.search.SearchService theRealSearchService, IssueManager issueManager, PermissionManager permissionManager) {
        this.searchProvider = searchProvider;
        this.searchRequestService = searchRequestService;
        this.customFieldManager = customFieldManager;
        this.soapUtilsBean = soapUtilsBean;
        this.projectManager = projectManager;
        this.attachmentManager = attachmentManager;
        this.requestAuthorizer = requestAuthorizer;
        this.theRealSearchService = theRealSearchService;
        this.issueRetriever = new IssueRetriever(issueManager, permissionManager);
    }

    @Override
    public RemoteIssue[] getIssues(User user, String filterId) throws RemoteException {
        PagerFilter unlimitedFilter = PagerFilter.getUnlimitedFilter();
        return this.getIssues(user, filterId, unlimitedFilter.getStart(), unlimitedFilter.getMax());
    }

    @Override
    public RemoteIssue[] getIssues(User user, String filterId, int offSet, int maxNumResults) throws RemoteException {
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(user);
        SearchRequest loadedSR = this.searchRequestService.getFilter((JiraServiceContext)ctx, new Long(filterId));
        if (loadedSR == null) {
            throw new RemoteValidationException("Could not find search request with id: " + filterId);
        }
        try {
            PagerFilter pagerFilter = new PagerFilter(maxNumResults);
            pagerFilter.setStart(offSet);
            this.validateNumResultsRespectGlobalConstraints(user, loadedSR, pagerFilter);
            List issues = this.searchProvider.search(loadedSR.getQuery(), user, pagerFilter).getIssues();
            return this.convertIssueObjectsToRemoteIssues(issues, user);
        }
        catch (SearchException e) {
            throw new RemoteException("Error occurred during searching: ", e);
        }
    }

    @Override
    public long getIssueCountForFilter(User user, String filterId) throws RemoteException {
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(user);
        SearchRequest searchRequest = this.searchRequestService.getFilter((JiraServiceContext)ctx, new Long(filterId));
        if (searchRequest == null) {
            throw new RemoteValidationException("Could not find search request with id: " + filterId);
        }
        try {
            return this.searchProvider.searchCount(searchRequest.getQuery(), user);
        }
        catch (SearchException e) {
            throw new RemoteException("Error occurred during searching: ", e);
        }
    }

    private RemoteIssue[] convertIssueObjectsToRemoteIssues(List issues, User user) throws RemoteException {
        RemoteIssue[] remoteIssues = new RemoteIssue[issues.size()];
        int i = 0;
        for (Object issueObject : issues) {
            Issue issue = (Issue)issueObject;
            IssueRetriever.IssueInfo issueInfo = this.issueRetriever.retrieveIssue(issue, user);
            remoteIssues[i] = new RemoteIssue(issueInfo.getIssue(), issueInfo.getParentIssue(), this.customFieldManager, this.attachmentManager, this.soapUtilsBean);
            ++i;
        }
        return remoteIssues;
    }

    @Override
    public RemoteIssue[] getIssuesFromTextSearch(User user, String searchTerms) throws RemoteException {
        PagerFilter unlimitedFilter = PagerFilter.getUnlimitedFilter();
        return this.getIssuesFromTextSearch(user, searchTerms, unlimitedFilter.getStart(), unlimitedFilter.getMax());
    }

    @Override
    public RemoteIssue[] getIssuesFromTextSearch(User user, String searchTerms, int offSet, int maxNumResults) throws RemoteException {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        SearchServiceImpl.addFreeTextCondition(jqlQueryBuilder.where(), searchTerms);
        SearchRequest searchRequest = SearchServiceImpl.makeRequest(user, jqlQueryBuilder);
        try {
            PagerFilter pagerFilter = new PagerFilter(maxNumResults);
            pagerFilter.setStart(offSet);
            return this.validateAndSearch(user, searchRequest, pagerFilter);
        }
        catch (SearchException e) {
            throw new RemoteException("Error occurred during searching: ", e);
        }
    }

    private RemoteIssue[] validateAndSearch(User user, SearchRequest searchRequest, PagerFilter pagerFilter) throws RemoteException, SearchException {
        this.validateNumResultsRespectGlobalConstraints(user, searchRequest, pagerFilter);
        MessageSet messageSet = this.theRealSearchService.validateQuery(user, searchRequest.getQuery());
        if (messageSet.hasAnyErrors()) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addErrorMessages((Collection)messageSet.getErrorMessages());
            throw new RemoteValidationException("Query validation failed:", (ErrorCollection)errorCollection);
        }
        List issues = this.theRealSearchService.search(user, searchRequest.getQuery(), pagerFilter).getIssues();
        return this.convertIssueObjectsToRemoteIssues(issues, user);
    }

    @Override
    public RemoteIssue[] getIssuesFromTextSearchWithProject(User user, String[] projectKeys, String searchTerms, int maxNumResults) throws RemoteException {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        SearchServiceImpl.addFreeTextCondition(jqlQueryBuilder.where(), searchTerms);
        if (projectKeys != null && projectKeys.length > 0) {
            List<Long> projectIds = this.convertKeysToIds(projectKeys);
            jqlQueryBuilder.where().and().project().inNumbers(projectIds);
        }
        SearchRequest searchRequest = SearchServiceImpl.makeRequest(user, jqlQueryBuilder);
        return this.issueSearchRequest(user, searchRequest, maxNumResults);
    }

    private RemoteIssue[] issueSearchRequest(User user, SearchRequest searchRequest, int maxNumResults) throws RemoteException {
        try {
            PagerFilter pager = new PagerFilter();
            pager.setMax(maxNumResults);
            return this.validateAndSearch(user, searchRequest, pager);
        }
        catch (SearchException e) {
            throw new RemoteException("Error occurred during searching: ", e);
        }
    }

    @Override
    public RemoteIssue[] getIssuesFromJqlSearch(User user, String jqlSearch, int maxNumResults) throws RemoteException {
        SearchService.ParseResult parseResult = this.theRealSearchService.parseQuery(user, jqlSearch);
        if (!parseResult.isValid()) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addErrorMessages((Collection)parseResult.getErrors().getErrorMessages());
            throw new RemoteValidationException("Parsing failed:", (ErrorCollection)errorCollection);
        }
        SearchRequest searchRequest = new SearchRequest(parseResult.getQuery());
        searchRequest.setOwnerUserName(user == null ? null : user.getName());
        return this.issueSearchRequest(user, searchRequest, maxNumResults);
    }

    private static JqlClauseBuilder addFreeTextCondition(JqlClauseBuilder builder, String searchTerms) {
        builder.sub();
        builder.addStringCondition("text", Operator.LIKE, searchTerms);
        builder.endsub();
        return builder;
    }

    private static SearchRequest makeRequest(User user, JqlQueryBuilder builder) {
        SearchRequest searchRequest = new SearchRequest(builder.buildQuery());
        searchRequest.setOwnerUserName(user == null ? null : user.getName());
        return searchRequest;
    }

    private List<Long> convertKeysToIds(String[] projectKeys) {
        if (projectKeys == null || projectKeys.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (String projectKey : projectKeys) {
            list.add(this.projectManager.getProjectObjByKey(projectKey).getId());
        }
        return list;
    }

    private void validateNumResultsRespectGlobalConstraints(User user, SearchRequest loadedSR, PagerFilter pagerFilter) throws RemoteException {
        Authorizer.Result authorizationResult = this.requestAuthorizer.isSearchRequestAuthorized(user, loadedSR, (SearchRequestParams)new SearchRequestParamsImpl(new HashMap(), pagerFilter));
        if (!authorizationResult.isOK()) {
            throw new RemoteException("Error occurred during searching: '" + authorizationResult.getReason() + "'.");
        }
    }
}

