/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.service;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.rpc.exception.RemotePermissionException;
import com.atlassian.jira.security.PermissionManager;

class IssueRetriever {
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;

    public IssueRetriever(IssueManager issueManager, PermissionManager permissionManager) {
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
    }

    IssueInfo retrieveIssue(String issueKey, User user) throws RemotePermissionException {
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        if (issue == null || !this.permissionManager.hasPermission(10, (Issue)issue, user)) {
            throw new RemotePermissionException("This issue does not exist or you don't have permission to view it.");
        }
        Issue parentIssue = this.retrieveParentIssue((Issue)issue, user);
        return new IssueInfo((Issue)issue, parentIssue);
    }

    IssueInfo retrieveIssue(Long issueId, User user) throws RemotePermissionException {
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null || !this.permissionManager.hasPermission(10, (Issue)issue, user)) {
            throw new RemotePermissionException("This issue does not exist or you don't have permission to view it.");
        }
        Issue parentIssue = this.retrieveParentIssue((Issue)issue, user);
        return new IssueInfo((Issue)issue, parentIssue);
    }

    IssueInfo retrieveIssue(Issue issue, User user) throws RemotePermissionException {
        if (issue == null || !this.permissionManager.hasPermission(10, issue.getGenericValue(), user)) {
            throw new RemotePermissionException("This issue does not exist or you don't have permission to view it.");
        }
        Issue parentIssue = this.retrieveParentIssue(issue, user);
        return new IssueInfo(issue, parentIssue);
    }

    private Issue retrieveParentIssue(Issue issue, User user) throws RemotePermissionException {
        Long parentId = issue.getParentId();
        if (parentId == null) {
            return null;
        }
        MutableIssue parentIssue = this.issueManager.getIssueObject(parentId);
        if (parentIssue != null && !this.permissionManager.hasPermission(10, (Issue)parentIssue, user)) {
            throw new RemotePermissionException("This issue does not exist or you don't have permission to view it.");
        }
        return parentIssue;
    }

    static class IssueInfo {
        private final Issue issue;
        private final Issue parentIssue;

        private IssueInfo(Issue issue, Issue parentIssue) {
            this.issue = issue;
            this.parentIssue = parentIssue;
        }

        public Issue getIssue() {
            return this.issue;
        }

        public Issue getParentIssue() {
            return this.parentIssue;
        }
    }
}

