/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.beans;

import com.atlassian.jira.rpc.soap.beans.RemoteProjectRole;
import com.atlassian.jira.rpc.soap.beans.RemoteRoleActor;
import com.atlassian.jira.rpc.soap.beans.RemoteUser;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RemoteRoleActors {
    private Set roleActors = null;
    private RemoteProjectRole remoteProjectRole = null;

    public RemoteRoleActors(RemoteProjectRole remoteProjectRole, RemoteRoleActor[] roleActors) {
        this.roleActors = new HashSet<RemoteRoleActor>(Arrays.asList(roleActors));
        this.remoteProjectRole = remoteProjectRole;
    }

    public RemoteUser[] getUsers() {
        HashSet<RemoteUser> remoteUsers = new HashSet<RemoteUser>();
        for (RemoteRoleActor remoteRoleActor : this.roleActors) {
            for (int j = 0; j < remoteRoleActor.getUsers().length; ++j) {
                RemoteUser remoteUser = remoteRoleActor.getUsers()[j];
                remoteUsers.add(remoteUser);
            }
        }
        return remoteUsers.toArray(new RemoteUser[remoteUsers.size()]);
    }

    private RemoteUser[] convertUsersListToArray(Set remoteUsers) {
        RemoteUser[] users = new RemoteUser[remoteUsers.size()];
        int i = 0;
        Iterator iterator = remoteUsers.iterator();
        while (iterator.hasNext()) {
            users[i] = (RemoteUser)iterator.next();
            ++i;
        }
        return users;
    }

    public RemoteRoleActor[] getRoleActors() {
        return this.convertRoleActorSetToArray(this.roleActors);
    }

    public RemoteProjectRole getProjectRole() {
        return this.remoteProjectRole;
    }

    public void addRoleActor(RemoteRoleActor roleActor) {
        this.roleActors.add(roleActor);
    }

    public void addRoleActors(Collection roleActors) {
        this.roleActors.addAll(roleActors);
    }

    public void removeRoleActor(RemoteRoleActor roleActor) {
        this.roleActors.remove(roleActor);
    }

    public void removeRoleActors(Collection roleActors) {
        this.roleActors.removeAll(roleActors);
    }

    public RemoteRoleActor[] getRoleActorsByType(String type) {
        HashSet<RemoteRoleActor> roleActorsForType = new HashSet<RemoteRoleActor>();
        for (RemoteRoleActor remoteRoleActor : this.roleActors) {
            if (!remoteRoleActor.getType().equals(type)) continue;
            roleActorsForType.add(remoteRoleActor);
        }
        return this.convertRoleActorSetToArray(roleActorsForType);
    }

    private RemoteRoleActor[] convertRoleActorSetToArray(Set roleActors) {
        RemoteRoleActor[] roleActorsArr = new RemoteRoleActor[roleActors.size()];
        int i = 0;
        Iterator iterator = roleActors.iterator();
        while (iterator.hasNext()) {
            roleActorsArr[i] = (RemoteRoleActor)iterator.next();
            ++i;
        }
        return roleActorsArr;
    }
}

