/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.beans;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rpc.soap.beans.AbstractNamedRemoteEntity;
import com.atlassian.jira.rpc.soap.beans.RemotePermissionScheme;
import com.atlassian.jira.rpc.soap.beans.RemoteScheme;
import org.ofbiz.core.entity.GenericValue;

public class RemoteProject
extends AbstractNamedRemoteEntity {
    String key;
    String url;
    String projectUrl;
    String lead;
    String description;
    RemoteScheme issueSecurityScheme;
    RemotePermissionScheme permissionScheme;
    RemoteScheme notificationScheme;

    public RemoteProject() {
    }

    public RemoteProject(Project project, ApplicationProperties applicationProperties) {
        super(project.getId() == null ? "" : project.getId().toString(), project.getName());
        this.key = project.getKey();
        this.url = applicationProperties.getString("jira.baseurl") + "/browse/" + this.key;
        this.projectUrl = project.getUrl();
        this.lead = project.getLeadUserName();
        this.description = project.getDescription();
    }

    public RemoteProject(GenericValue project, ApplicationProperties applicationProperties) {
        super(project);
        this.key = project.getString("key");
        this.url = applicationProperties.getString("jira.baseurl") + "/browse/" + this.key;
        this.projectUrl = project.getString("url");
        this.lead = project.getString("lead");
        this.description = project.getString("description");
    }

    public String getKey() {
        return this.key;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public void setProjectUrl(String projectUrl) {
        this.projectUrl = projectUrl;
    }

    public String getLead() {
        return this.lead;
    }

    public void setLead(String lead) {
        this.lead = lead;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RemoteScheme getIssueSecurityScheme() {
        return this.issueSecurityScheme;
    }

    public void setIssueSecurityScheme(RemoteScheme issueSecurityScheme) {
        this.issueSecurityScheme = issueSecurityScheme;
    }

    public RemotePermissionScheme getPermissionScheme() {
        return this.permissionScheme;
    }

    public void setPermissionScheme(RemotePermissionScheme permissionScheme) {
        this.permissionScheme = permissionScheme;
    }

    public RemoteScheme getNotificationScheme() {
        return this.notificationScheme;
    }

    public void setNotificationScheme(RemoteScheme notificationScheme) {
        this.notificationScheme = notificationScheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteProject)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoteProject remoteProject = (RemoteProject)o;
        if (this.description != null ? !this.description.equals(remoteProject.description) : remoteProject.description != null) {
            return false;
        }
        if (this.issueSecurityScheme != null ? !this.issueSecurityScheme.equals(remoteProject.issueSecurityScheme) : remoteProject.issueSecurityScheme != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(remoteProject.key) : remoteProject.key != null) {
            return false;
        }
        if (this.lead != null ? !this.lead.equals(remoteProject.lead) : remoteProject.lead != null) {
            return false;
        }
        if (this.notificationScheme != null ? !this.notificationScheme.equals(remoteProject.notificationScheme) : remoteProject.notificationScheme != null) {
            return false;
        }
        if (this.permissionScheme != null ? !this.permissionScheme.equals(remoteProject.permissionScheme) : remoteProject.permissionScheme != null) {
            return false;
        }
        if (this.projectUrl != null ? !this.projectUrl.equals(remoteProject.projectUrl) : remoteProject.projectUrl != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(remoteProject.url) : remoteProject.url != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 29 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 29 * result + (this.projectUrl != null ? this.projectUrl.hashCode() : 0);
        result = 29 * result + (this.lead != null ? this.lead.hashCode() : 0);
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 29 * result + (this.issueSecurityScheme != null ? this.issueSecurityScheme.hashCode() : 0);
        result = 29 * result + (this.permissionScheme != null ? this.permissionScheme.hashCode() : 0);
        result = 29 * result + (this.notificationScheme != null ? this.notificationScheme.hashCode() : 0);
        return result;
    }
}

