/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.soap.beans;

import com.atlassian.jira.config.properties.ApplicationProperties;

public class RemoteConfiguration {
    private boolean allowAttachments = false;
    private boolean allowUnassignedIssues = false;
    private boolean allowVoting = false;
    private boolean allowWatching = false;
    private boolean allowTimeTracking = false;
    private boolean allowSubTasks = false;
    private boolean allowIssueLinking = false;
    private boolean allowExternalUserManagment = false;
    private int timeTrackingHoursPerDay;
    private int timeTrackingDaysPerWeek;

    public RemoteConfiguration(ApplicationProperties applicationProperties) {
        this.allowAttachments = applicationProperties.getOption("jira.option.allowattachments");
        this.allowVoting = applicationProperties.getOption("jira.option.voting");
        this.allowWatching = applicationProperties.getOption("jira.option.watching");
        this.allowUnassignedIssues = applicationProperties.getOption("jira.option.allowunassigned");
        this.allowTimeTracking = applicationProperties.getOption("jira.option.timetracking");
        this.allowSubTasks = applicationProperties.getOption("jira.option.allowsubtasks");
        this.allowIssueLinking = applicationProperties.getOption("jira.option.issuelinking");
        this.allowExternalUserManagment = applicationProperties.getOption("jira.option.user.externalmanagement");
        this.timeTrackingHoursPerDay = Integer.parseInt(applicationProperties.getDefaultBackedString("jira.timetracking.hours.per.day"));
        this.timeTrackingDaysPerWeek = Integer.parseInt(applicationProperties.getDefaultBackedString("jira.timetracking.days.per.week"));
    }

    public int getTimeTrackingHoursPerDay() {
        return this.timeTrackingHoursPerDay;
    }

    public int getTimeTrackingDaysPerWeek() {
        return this.timeTrackingDaysPerWeek;
    }

    public boolean isAllowAttachments() {
        return this.allowAttachments;
    }

    public boolean isAllowTimeTracking() {
        return this.allowTimeTracking;
    }

    public boolean isAllowUnassignedIssues() {
        return this.allowUnassignedIssues;
    }

    public boolean isAllowVoting() {
        return this.allowVoting;
    }

    public boolean isAllowWatching() {
        return this.allowWatching;
    }

    public boolean isAllowSubTasks() {
        return this.allowSubTasks;
    }

    public boolean isAllowIssueLinking() {
        return this.allowIssueLinking;
    }

    public boolean isAllowExternalUserManagment() {
        return this.allowExternalUserManagment;
    }
}

