/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rpc.auth;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenMap<K, V>
extends HashMap<K, V> {
    private final long tokenTimeout;
    private final Map<Object, Long> tokenTimeouts;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock r = this.rwLock.readLock();
    private final Lock w = this.rwLock.writeLock();

    public TokenMap(long tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
        this.tokenTimeouts = new HashMap<Object, Long>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.w.lock();
        try {
            this.tokenTimeouts.put(key, this.nextExpiryTime());
            V v = super.put(key, value);
            return v;
        }
        finally {
            this.w.unlock();
        }
    }

    private Long nextExpiryTime() {
        return System.currentTimeMillis() + this.tokenTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        this.r.lock();
        try {
            if (!super.containsKey(key)) {
                V v = null;
                return v;
            }
            Long expiryTime = this.tokenTimeouts.get(key);
            if (expiryTime == null) {
                this.tokenTimeouts.remove(key);
                super.remove(key);
                V v = null;
                return v;
            }
            if (expiryTime < System.currentTimeMillis()) {
                this.tokenTimeouts.remove(key);
                super.remove(key);
                V v = null;
                return v;
            }
            this.tokenTimeouts.put(key, this.nextExpiryTime());
            Object v = super.get(key);
            return v;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        this.r.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            this.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.w.lock();
        try {
            this.tokenTimeouts.remove(key);
            Object v = super.remove(key);
            return v;
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.w.lock();
        try {
            this.tokenTimeouts.clear();
            super.clear();
        }
        finally {
            this.w.unlock();
        }
    }
}

