/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.cache;

import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.AuthenticationManager;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.util.Assert;
import java.rmi.RemoteException;

public class SimpleAuthenticationManager
implements AuthenticationManager {
    private final SecurityServerClient securityServerClient;

    public SimpleAuthenticationManager(SecurityServerClient securityServerClient) {
        this.securityServerClient = securityServerClient;
    }

    public String authenticate(UserAuthenticationContext authenticationContext) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        Assert.notNull(authenticationContext);
        if (authenticationContext.getApplication() == null) {
            authenticationContext.setApplication(this.getSecurityServerClient().getSoapClientProperties().getApplicationName());
        }
        return this.getSecurityServerClient().authenticatePrincipal(authenticationContext);
    }

    public String authenticateWithoutValidatingPassword(UserAuthenticationContext authenticationContext) throws ApplicationAccessDeniedException, InvalidAuthenticationException, InvalidAuthorizationTokenException, InactiveAccountException, RemoteException {
        Assert.notNull(authenticationContext);
        return this.getSecurityServerClient().createPrincipalToken(authenticationContext.getName(), authenticationContext.getValidationFactors());
    }

    public String authenticate(String username, String password) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        Assert.notNull(username);
        Assert.notNull(password);
        return this.getSecurityServerClient().authenticatePrincipalSimple(username, password);
    }

    public boolean isAuthenticated(String token, ValidationFactor[] validationFactors) throws RemoteException, InvalidAuthorizationTokenException, ApplicationAccessDeniedException, InvalidAuthenticationException {
        Assert.notNull(token);
        return this.getSecurityServerClient().isValidToken(token, validationFactors);
    }

    public void invalidate(String token) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        Assert.notNull(token);
        this.getSecurityServerClient().invalidateToken(token);
    }

    public SecurityServerClient getSecurityServerClient() {
        return this.securityServerClient;
    }
}

