/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.jive;

import com.atlassian.crowd.integration.jive.CrowdGroup;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.service.soap.client.SecurityServerClientFactory;
import com.jivesoftware.base.Group;
import com.jivesoftware.base.GroupAlreadyExistsException;
import com.jivesoftware.base.GroupManager;
import com.jivesoftware.base.GroupManagerFactory;
import com.jivesoftware.base.GroupNotFoundException;
import com.jivesoftware.base.Log;
import com.jivesoftware.base.UnauthorizedException;
import com.jivesoftware.base.User;
import com.jivesoftware.base.UserManager;
import com.jivesoftware.base.UserManagerFactory;
import com.jivesoftware.base.UserNotFoundException;
import com.jivesoftware.base.database.GroupIterator;
import com.jivesoftware.util.LongList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CrowdGroupManager
implements GroupManager {
    private final SecurityServerClient securityServerClient;
    private UserManager userManager;
    private long expiresStamp;
    private static final int CACHE_TIME = 5;
    private static final long CACHE_TIME_IN_MINUTES = 300000L;

    public CrowdGroupManager() {
        this(SecurityServerClientFactory.getSecurityServerClient());
    }

    public CrowdGroupManager(SecurityServerClient securityServerClient) {
        this.securityServerClient = securityServerClient;
        this.expiresStamp = System.currentTimeMillis();
        UserManagerFactory.doInitialize();
        this.userManager = UserManagerFactory.getInstance();
        this.getGroups();
    }

    public Group createGroup(String name) throws GroupAlreadyExistsException {
        throw new UnsupportedOperationException("Creating new groups is not supported.");
    }

    public Group getGroup(long groupID) throws GroupNotFoundException {
        Group group = (Group)GroupManagerFactory.groupCache.get((Object)new Long(groupID));
        if (group != null) {
            return group;
        }
        group = new CrowdGroup(groupID);
        if (group.getName() != null) {
            return this.getGroup(group.getName());
        }
        throw new GroupNotFoundException("Could not load group for ID " + groupID);
    }

    public Group getGroup(String name) throws GroupNotFoundException {
        return this.findGroupByNameFromCrowd(name);
    }

    public void deleteGroup(Group group) throws UnauthorizedException {
        throw new UnsupportedOperationException("Deleting a group is not supported.");
    }

    public int getGroupCount() {
        return this.findAllGroupsFromCrowd().size();
    }

    public Iterator getGroups() {
        return this.findAllGroupsFromCrowd().iterator();
    }

    public Iterator getGroups(int startIndex, int numResults) {
        List groups = this.findAllGroupsFromCrowd();
        if (startIndex < groups.size() || numResults <= 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (startIndex + numResults < groups.size()) {
            return new ArrayList(groups.subList(startIndex, startIndex + numResults)).iterator();
        }
        return new ArrayList(groups.subList(startIndex, groups.size())).iterator();
    }

    public Iterator getUserGroups(User user) {
        long userID = user.getID();
        String key = "userGroups-" + userID;
        long[] groups = (long[])GroupManagerFactory.groupMemberCache.get((Object)key);
        if (groups == null) {
            groups = this.lookupGroupsForUserFromCrowd(user);
            GroupManagerFactory.groupMemberCache.put((Object)key, (Object)groups);
        }
        if (groups == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return new GroupIterator(groups);
    }

    public LongList getGroupIDs(User user) {
        long userID = user.getID();
        String key = "userGroups-" + userID;
        long[] groups = (long[])GroupManagerFactory.groupMemberCache.get((Object)key);
        if (groups == null) {
            groups = this.lookupGroupsForUserFromCrowd(user);
            GroupManagerFactory.groupMemberCache.put((Object)key, (Object)groups);
        }
        if (groups == null) {
            return new LongList(0);
        }
        return new LongList(groups);
    }

    private long[] lookupGroupsForUserFromCrowd(User user) {
        LongList groupIDs = new LongList();
        try {
            String[] groupNames = this.securityServerClient.findGroupMemberships(user.getUsername());
            for (int i = 0; i < groupNames.length; ++i) {
                String groupName = groupNames[i];
                try {
                    Group group = this.findGroupByNameFromCrowd(groupName);
                    groupIDs.add(group.getID());
                    continue;
                }
                catch (GroupNotFoundException e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            Log.error((String)("Could not find group memberships of user from Crowd: " + user.getUsername()), (Throwable)e);
        }
        return groupIDs.toArray();
    }

    private List findAllGroupsFromCrowd() {
        if (System.currentTimeMillis() < this.expiresStamp) {
            return new ArrayList(GroupManagerFactory.groupCache.values());
        }
        Log.debug((String)"Querying all groups from Crowd.");
        ArrayList<Group> groups = new ArrayList<Group>();
        try {
            SOAPGroup[] remoteGroups = this.securityServerClient.findAllGroups();
            Log.debug((String)(remoteGroups.length + " groups found."));
            for (int i = 0; i < remoteGroups.length; ++i) {
                Group group = this.remoteGroupToCrowdGroup(remoteGroups[i]);
                groups.add(this.updateGroupCache(group));
            }
        }
        catch (Exception e) {
            Log.error((String)"Error occured while trying to find all groups on Crowd Server", (Throwable)e);
        }
        Log.debug((String)("Total of " + groups.size() + " groups returned."));
        this.expiresStamp = System.currentTimeMillis() + 300000L;
        return groups;
    }

    private Group remoteGroupToCrowdGroup(SOAPGroup remoteGroup) {
        Log.debug((String)("Converting remote group '" + remoteGroup.getName() + "' from Crowd into its local Jive equivalent."));
        String name = remoteGroup.getName();
        String description = remoteGroup.getDescription();
        ArrayList<User> members = new ArrayList<User>();
        String[] membersArray = remoteGroup.getMembers();
        if (membersArray != null && membersArray.length > 0) {
            Log.debug((String)("Remote group '" + name + "' has " + membersArray.length + " members."));
            for (int i = 0; i < membersArray.length; ++i) {
                String username = membersArray[i];
                if (!StringUtils.isNotBlank((String)username)) continue;
                try {
                    User user = this.userManager.getUser(username);
                    members.add(user);
                    continue;
                }
                catch (UserNotFoundException e) {
                    Log.debug((String)("User in group '" + remoteGroup.getName() + "' not found in Jive: " + username));
                }
            }
        } else {
            Log.debug((String)("Remote group '" + remoteGroup.getName() + "' has no members."));
        }
        Log.debug((String)("Conversion of remote group '" + remoteGroup.getName() + "' is complete. " + members.size() + " members populated."));
        return new CrowdGroup(name, description, members);
    }

    private Group findGroupByNameFromCrowd(String name) throws GroupNotFoundException {
        Group group;
        Long cachedID = (Long)GroupManagerFactory.groupIDCache.get((Object)name);
        if (cachedID != null && (group = (Group)GroupManagerFactory.groupCache.get((Object)cachedID)) != null) {
            return group;
        }
        try {
            SOAPGroup remoteGroup = this.securityServerClient.findGroupByName(name);
            return this.updateGroupCache(this.remoteGroupToCrowdGroup(remoteGroup));
        }
        catch (Exception e) {
            throw new GroupNotFoundException("Could not load group with name " + name, (Throwable)e);
        }
    }

    private Group updateGroupCache(Group group) {
        Long groupId = new Long(group.getID());
        GroupManagerFactory.groupIDCache.put((Object)group.getName(), (Object)groupId);
        GroupManagerFactory.groupCache.put((Object)groupId, (Object)group);
        return group;
    }
}

