/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.DirectoryCacheChangeOperations;
import com.atlassian.crowd.directory.TimerStack;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryCacheImplUsingChangeOperations
implements DirectoryCache {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryCacheImplUsingChangeOperations.class);
    private final DirectoryCacheChangeOperations dc;

    public DirectoryCacheImplUsingChangeOperations(DirectoryCacheChangeOperations dc) {
        this.dc = dc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateCachedUsers(List<? extends User> remoteUsers, Date syncStartDate) throws OperationFailedException {
        TimerStack.push();
        try {
            Set<UserTemplate> usersToUpdate;
            Set<UserTemplateWithCredentialAndAttributes> usersToAdd;
            TimerStack.push();
            try {
                DirectoryCacheChangeOperations.AddUpdateSets<UserTemplateWithCredentialAndAttributes, UserTemplate> result = this.dc.getUsersToAddAndUpdate(remoteUsers, syncStartDate);
                usersToAdd = result.getToAddSet();
                usersToUpdate = result.getToUpdateSet();
            }
            finally {
                logger.info(TimerStack.pop("scanned and compared [ " + remoteUsers.size() + " ] users for update in DB cache in [ {0} ]"));
            }
            this.dc.addUsers(usersToAdd);
            this.dc.updateUsers(usersToUpdate);
        }
        finally {
            logger.info(TimerStack.pop("synchronised [ " + remoteUsers.size() + " ] users in [ {0} ]"));
        }
    }

    public void deleteCachedUsers(Set<String> usernames) throws OperationFailedException {
        this.dc.deleteCachedUsers(usernames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateCachedGroups(List<? extends Group> remoteGroups, Date syncStartDate) throws OperationFailedException {
        logger.info("scanning [ {} ] groups to add or update", (Object)remoteGroups.size());
        TimerStack.push();
        try {
            DirectoryCacheChangeOperations.GroupsToAddUpdateReplace addUpdateReplace = this.dc.findGroupsToUpdate(remoteGroups, syncStartDate);
            logger.debug("replacing [ {} ] groups", (Object)addUpdateReplace.groupsToReplace.size());
            this.dc.removeGroups(addUpdateReplace.groupsToReplace.keySet());
            HashSet<GroupTemplate> allToAdd = new HashSet<GroupTemplate>();
            allToAdd.addAll(addUpdateReplace.groupsToAdd);
            allToAdd.addAll(addUpdateReplace.groupsToReplace.values());
            this.dc.addGroups(allToAdd);
            this.dc.updateGroups(addUpdateReplace.groupsToUpdate);
        }
        finally {
            logger.info(TimerStack.pop("synchronized [ " + remoteGroups.size() + " ] groups in [ {0} ]"));
        }
    }

    public void deleteCachedGroupsNotIn(GroupType groupType, List<? extends Group> remoteGroups, Date syncStartDate) throws OperationFailedException {
        this.dc.deleteCachedGroupsNotIn(groupType, remoteGroups, syncStartDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncUserMembershipsForGroup(Group group, List<String> remoteUsers) throws OperationFailedException {
        TimerStack.push();
        try {
            if (this.dc.ignoreGroupOnSynchroniseMemberships(group)) {
                return;
            }
            DirectoryCacheChangeOperations.AddRemoveSets<String> addRemove = this.dc.findUserMembershipForGroupChanges(group, remoteUsers);
            logger.debug("adding [ " + addRemove.toAdd.size() + " ] users to group [ " + group.getName() + " ]");
            logger.debug("removing [ " + addRemove.toRemove.size() + " ] users from group [ " + group.getName() + " ]");
            this.dc.addUserMembershipsForGroup(group, addRemove.toAdd);
            this.dc.removeUserMembershipsForGroup(group, addRemove.toRemove);
        }
        finally {
            logger.debug(TimerStack.pop("synchronised [ " + remoteUsers.size() + " ] user members for group [ " + group.getName() + " ] in [ {0} ]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncGroupMembershipsForGroup(Group parentGroup, List<String> remoteGroups) throws OperationFailedException {
        if (this.dc.ignoreGroupOnSynchroniseMemberships(parentGroup)) {
            return;
        }
        TimerStack.push();
        try {
            DirectoryCacheChangeOperations.AddRemoveSets<String> addRemove = this.dc.findGroupMembershipForGroupChanges(parentGroup, remoteGroups);
            logger.debug("adding [ " + addRemove.toAdd.size() + " ] group members from group [ " + parentGroup.getName() + " ]");
            logger.debug("removing [ " + addRemove.toRemove.size() + " ] group members to group [ " + parentGroup.getName() + " ]");
            this.dc.addGroupMembershipsForGroup(parentGroup, addRemove.toAdd);
            this.dc.removeGroupMembershipsForGroup(parentGroup, addRemove.toRemove);
        }
        finally {
            logger.debug(TimerStack.pop("synchronised [ " + remoteGroups.size() + " ] group members for group [ " + parentGroup.getName() + " ] in [ {0} ]"));
        }
    }

    public void deleteCachedGroups(Set<String> groupnames) throws OperationFailedException {
        this.dc.deleteCachedGroups(groupnames);
    }

    public void deleteCachedUsersNotIn(List<? extends User> users, Date syncStartDate) throws OperationFailedException {
        this.dc.deleteCachedUsersNotIn(users, syncStartDate);
    }
}

