/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.CanonicalizerSpi;
import org.apache.xml.security.c14n.helper.C14nHelper;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public abstract class CanonicalizerBase
extends CanonicalizerSpi {
    boolean _includeComments = false;
    Set _xpathNodeSet = null;
    Document _doc = null;
    Element _documentElement = null;
    Node _rootNodeOfC14n = null;
    Writer _writer = null;
    Set _inclusiveNSSet = null;
    HashMap _renderedPrefixesForElement = null;
    static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;

    public CanonicalizerBase(boolean bl) {
        this._includeComments = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] engineCanonicalizeSubTree(Node node) throws CanonicalizationException {
        this._rootNodeOfC14n = node;
        this._doc = XMLUtils.getOwnerDocument(this._rootNodeOfC14n);
        this._documentElement = this._doc.getDocumentElement();
        XMLUtils.circumventBug2650(this._doc);
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
                this.canonicalizeSubTree(this._rootNodeOfC14n);
                this._writer.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Object var5_6 = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CanonicalizationException("empty", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new CanonicalizationException("empty", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    void canonicalizeSubTree(Node node) throws CanonicalizationException, IOException {
        short s = node.getNodeType();
        switch (s) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.canonicalizeSubTree(node2);
                }
                break;
            }
            case 8: {
                if (!this._includeComments) break;
                int n = CanonicalizerBase.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputCommentToWriter((Comment)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 7: {
                int n = CanonicalizerBase.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputPItoWriter((ProcessingInstruction)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 3: 
            case 4: {
                this.outputTextToWriter(node.getNodeValue());
                break;
            }
            case 1: {
                Element element = (Element)node;
                this._writer.write("<");
                this._writer.write(element.getTagName());
                Object[] objectArray = this.handleAttributesSubtree(element);
                for (int i = 0; i < objectArray.length; ++i) {
                    this.outputAttrToWriter(((Attr)objectArray[i]).getNodeName(), ((Attr)objectArray[i]).getNodeValue());
                }
                this._writer.write(">");
                for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    this.canonicalizeSubTree(node3);
                }
                this._writer.write("</");
                this._writer.write(element.getTagName());
                this._writer.write(">");
            }
        }
    }

    static int getPositionRelativeToDocumentElement(Node node) {
        if (node == null) {
            return 0;
        }
        Document document = node.getOwnerDocument();
        if (node.getParentNode() != document) {
            return 0;
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return 0;
        }
        if (element == node) {
            return 0;
        }
        for (Node node2 = node; node2 != null; node2 = node2.getNextSibling()) {
            if (node2 != element) continue;
            return -1;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] engineCanonicalizeXPathNodeSet(Set set, String string) throws CanonicalizationException {
        this._xpathNodeSet = set;
        if (this._xpathNodeSet.size() == 0) {
            return new byte[0];
        }
        Object object = (Node)this._xpathNodeSet.iterator().next();
        this._doc = XMLUtils.getOwnerDocument((Node)object);
        this._documentElement = this._doc.getDocumentElement();
        try {
            try {
                object = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)object, "UTF8");
                this.canonicalizeXPathNodeSet(this._doc);
                this._writer.close();
                byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
                Object var6_7 = null;
                this._xpathNodeSet = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CanonicalizationException("empty", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new CanonicalizationException("empty", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this._xpathNodeSet = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] engineCanonicalizeXPathNodeSet(Set set) throws CanonicalizationException {
        this._xpathNodeSet = set;
        if (this._xpathNodeSet.size() == 0) {
            return new byte[0];
        }
        if (this._doc == null) {
            this._doc = XMLUtils.getOwnerDocument(this._xpathNodeSet);
            this._documentElement = this._doc.getDocumentElement();
            this._rootNodeOfC14n = this._doc;
        }
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this._writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
                this.canonicalizeXPathNodeSet(this._rootNodeOfC14n);
                this._writer.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                Object var5_6 = null;
                this._xpathNodeSet = null;
                this._rootNodeOfC14n = null;
                this._doc = null;
                this._documentElement = null;
                this._writer = null;
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new CanonicalizationException("empty", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new CanonicalizationException("empty", iOException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this._xpathNodeSet = null;
            this._rootNodeOfC14n = null;
            this._doc = null;
            this._documentElement = null;
            this._writer = null;
            throw throwable;
        }
    }

    void canonicalizeXPathNodeSet(Node node) throws CanonicalizationException, IOException {
        short s = node.getNodeType();
        boolean bl = this._xpathNodeSet.contains(node);
        switch (s) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.canonicalizeXPathNodeSet(node2);
                }
                break;
            }
            case 8: {
                if (!this._includeComments || !this._xpathNodeSet.contains(node)) break;
                int n = CanonicalizerBase.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputCommentToWriter((Comment)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 7: {
                if (!this._xpathNodeSet.contains(node)) break;
                int n = CanonicalizerBase.getPositionRelativeToDocumentElement(node);
                if (n == 1) {
                    this._writer.write("\n");
                }
                this.outputPItoWriter((ProcessingInstruction)node);
                if (n != -1) break;
                this._writer.write("\n");
                break;
            }
            case 3: 
            case 4: {
                if (!this._xpathNodeSet.contains(node)) break;
                this.outputTextToWriter(node.getNodeValue());
                for (Node node3 = node.getNextSibling(); node3 != null && (node3.getNodeType() == 3 || node3.getNodeType() == 4); node3 = node3.getNextSibling()) {
                    this.outputTextToWriter(node3.getNodeValue());
                }
                break;
            }
            case 1: {
                Element element = (Element)node;
                if (bl) {
                    this._writer.write("<");
                    this._writer.write(element.getTagName());
                }
                Object[] objectArray = this.handleAttributes(element);
                objectArray = C14nHelper.sortAttributes(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    Attr attr = (Attr)objectArray[i];
                    this.outputAttrToWriter(attr.getNodeName(), attr.getNodeValue());
                }
                if (bl) {
                    this._writer.write(">");
                }
                for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    this.canonicalizeXPathNodeSet(node4);
                }
                if (!bl) break;
                this._writer.write("</");
                this._writer.write(element.getTagName());
                this._writer.write(">");
            }
        }
    }

    void outputAttrToWriter(String string, String string2) throws IOException {
        this._writer.write(" ");
        this._writer.write(string);
        this._writer.write("=\"");
        int n = string2.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '&': {
                    this._writer.write("&amp;");
                    continue block8;
                }
                case '<': {
                    this._writer.write("&lt;");
                    continue block8;
                }
                case '\"': {
                    this._writer.write("&quot;");
                    continue block8;
                }
                case '\t': {
                    this._writer.write("&#x9;");
                    continue block8;
                }
                case '\n': {
                    this._writer.write("&#xA;");
                    continue block8;
                }
                case '\r': {
                    this._writer.write("&#xD;");
                    continue block8;
                }
                default: {
                    this._writer.write(c);
                }
            }
        }
        this._writer.write("\"");
    }

    void outputPItoWriter(ProcessingInstruction processingInstruction) throws IOException {
        int n;
        this._writer.write("<?");
        String string = processingInstruction.getTarget();
        int n2 = string.length();
        block6: for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            switch (n) {
                case 13: {
                    this._writer.write("&#xD;");
                    continue block6;
                }
                default: {
                    this._writer.write(n);
                }
            }
        }
        String string2 = processingInstruction.getData();
        n2 = string2.length();
        if (string2 != null && n2 > 0) {
            this._writer.write(" ");
            block7: for (n = 0; n < n2; ++n) {
                char c = string2.charAt(n);
                switch (c) {
                    case '\r': {
                        this._writer.write("&#xD;");
                        continue block7;
                    }
                    default: {
                        this._writer.write(c);
                    }
                }
            }
        }
        this._writer.write("?>");
    }

    void outputCommentToWriter(Comment comment) throws IOException {
        this._writer.write("<!--");
        String string = comment.getData();
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    this._writer.write("&#xD;");
                    continue block3;
                }
                default: {
                    this._writer.write(c);
                }
            }
        }
        this._writer.write("-->");
    }

    void outputTextToWriter(String string) throws IOException {
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    this._writer.write("&amp;");
                    continue block6;
                }
                case '<': {
                    this._writer.write("&lt;");
                    continue block6;
                }
                case '>': {
                    this._writer.write("&gt;");
                    continue block6;
                }
                case '\r': {
                    this._writer.write("&#xD;");
                    continue block6;
                }
                default: {
                    this._writer.write(c);
                }
            }
        }
    }

    abstract Object[] handleAttributes(Element var1) throws CanonicalizationException;

    abstract Object[] handleAttributesSubtree(Element var1) throws CanonicalizationException;
}

