/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.velocity.util.introspection.MethodMap;

public class ClassMap {
    private static final Method CACHE_MISS;
    private static final Object NULL_ARGUMENT;
    private final ConcurrentMap<MethodKey, Method> methodCache = CopyOnWriteMap.newHashMap();
    private final MethodMap methodMap;

    public ClassMap(Class<?> clazz) {
        Method[] methods = ClassMap.getAccessibleMethods(clazz);
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        for (Method method : methods) {
            Method publicMethod = ClassMap.getPublicMethod(method);
            if (publicMethod == null) continue;
            publicMethods.add(publicMethod);
            this.methodCache.putIfAbsent(new MethodKey(publicMethod), publicMethod);
        }
        this.methodMap = new MethodMap(publicMethods);
    }

    public Method findMethod(String name, Object[] params) throws MethodMap.AmbiguousException {
        MethodKey methodKey = new MethodKey(name, params);
        Method cacheEntry = (Method)this.methodCache.get(methodKey);
        if (cacheEntry == CACHE_MISS) {
            return null;
        }
        if (cacheEntry == null) {
            try {
                cacheEntry = this.methodMap.find(name, params);
            }
            catch (MethodMap.AmbiguousException ae) {
                this.methodCache.putIfAbsent(methodKey, CACHE_MISS);
                throw ae;
            }
            if (cacheEntry == null) {
                this.methodCache.putIfAbsent(methodKey, CACHE_MISS);
            } else {
                this.methodCache.putIfAbsent(methodKey, cacheEntry);
            }
        }
        return cacheEntry;
    }

    private static Method[] getAccessibleMethods(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return methods;
        }
        MethodInfo[] methodInfos = new MethodInfo[methods.length];
        int i = methods.length;
        while (i-- > 0) {
            methodInfos[i] = new MethodInfo(methods[i]);
        }
        int upcastCount = ClassMap.getAccessibleMethods(clazz, methodInfos, 0);
        if (upcastCount < methods.length) {
            methods = new Method[upcastCount];
        }
        int j = 0;
        for (int i2 = 0; i2 < methodInfos.length; ++i2) {
            MethodInfo methodInfo = methodInfos[i2];
            if (!methodInfo.upcast) continue;
            methods[j++] = methodInfo.method;
        }
        return methods;
    }

    private static int getAccessibleMethods(Class<?> clazz, MethodInfo[] methodInfos, int upcastCount) {
        Class<?> superclazz;
        int l = methodInfos.length;
        if (Modifier.isPublic(clazz.getModifiers())) {
            for (int i = 0; i < l && upcastCount < l; ++i) {
                try {
                    MethodInfo methodInfo = methodInfos[i];
                    if (methodInfo.upcast) continue;
                    methodInfo.tryUpcasting(clazz);
                    ++upcastCount;
                    continue;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (upcastCount == l) {
                return upcastCount;
            }
        }
        if ((superclazz = clazz.getSuperclass()) != null && (upcastCount = ClassMap.getAccessibleMethods(superclazz, methodInfos, upcastCount)) == l) {
            return upcastCount;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i = interfaces.length;
        while (i-- > 0) {
            if ((upcastCount = ClassMap.getAccessibleMethods(interfaces[i], methodInfos, upcastCount)) != l) continue;
            return upcastCount;
        }
        return upcastCount;
    }

    public static Method getPublicMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if ((clazz.getModifiers() & 1) != 0) {
            return method;
        }
        return ClassMap.getPublicMethod(clazz, method.getName(), method.getParameterTypes());
    }

    private static Method getPublicMethod(Class<?> clazz, String name, Class<?>[] paramTypes) {
        Method superclazzMethod;
        if ((clazz.getModifiers() & 1) != 0) {
            try {
                return clazz.getMethod(name, paramTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz != null && (superclazzMethod = ClassMap.getPublicMethod(superclazz, name, paramTypes)) != null) {
            return superclazzMethod;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Method interfaceMethod = ClassMap.getPublicMethod(interfaces[i], name, paramTypes);
            if (interfaceMethod == null) continue;
            return interfaceMethod;
        }
        return null;
    }

    static {
        try {
            CACHE_MISS = CacheMiss.class.getDeclaredMethod("miss", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        NULL_ARGUMENT = new Object();
    }

    private static final class MethodInfo {
        Method method = null;
        String name;
        Class<?>[] parameterTypes;
        boolean upcast;

        MethodInfo(Method method) {
            this.name = method.getName();
            this.parameterTypes = method.getParameterTypes();
            this.upcast = false;
        }

        void tryUpcasting(Class<?> clazz) throws NoSuchMethodException {
            this.method = clazz.getMethod(this.name, this.parameterTypes);
            this.name = null;
            this.parameterTypes = null;
            this.upcast = true;
        }
    }

    private static final class MethodKey {
        private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPES;
        private final String method;
        private final Class<?>[] params;
        private int hash;

        MethodKey(String method, Object[] params) {
            this.method = method;
            this.params = MethodKey.getArgumentTypes(params);
        }

        MethodKey(Method method) {
            this.method = method.getName();
            this.params = MethodKey.canonicalizeParameterTypes(method);
        }

        public int hashCode() {
            if (this.hash == 0) {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.method.hashCode();
                this.hash = result = 31 * result + Arrays.hashCode(this.params);
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != MethodKey.type(obj)) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            return this.method.equals(other.method) && Arrays.equals(this.params, other.params);
        }

        private static Class<?>[] getArgumentTypes(Object[] params) {
            Class[] result = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                result[i] = MethodKey.type(params[i]);
            }
            return result;
        }

        private static Class<?>[] canonicalizeParameterTypes(Method method) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypes[i] = MethodKey.canonicalType(parameterTypes[i]);
            }
            return parameterTypes;
        }

        private static Class<? extends Object> type(Object arg) {
            return MethodKey.canonicalType(MethodKey.canonicalArg(arg).getClass());
        }

        private static Class<? extends Object> canonicalType(Class<?> result) {
            if (!result.isPrimitive()) {
                return result;
            }
            return PRIMITIVE_TYPES.get(result);
        }

        private static Object canonicalArg(Object obj) {
            return obj != null ? obj : NULL_ARGUMENT;
        }

        static {
            HashMap<Class<Comparable<Boolean>>, Class> map = new HashMap<Class<Comparable<Boolean>>, Class>();
            map.put(Boolean.TYPE, Boolean.class);
            map.put(Byte.TYPE, Byte.class);
            map.put(Character.TYPE, Character.class);
            map.put(Double.TYPE, Double.class);
            map.put(Float.TYPE, Float.class);
            map.put(Integer.TYPE, Integer.class);
            map.put(Long.TYPE, Long.class);
            map.put(Short.TYPE, Short.class);
            PRIMITIVE_TYPES = Collections.unmodifiableMap(map);
        }
    }

    static final class CacheMiss {
        CacheMiss() {
        }

        void miss() {
        }
    }
}

