/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.velocity.Template;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.VelocimacroManager;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.VelocimacroProxy;

public class VelocimacroFactory {
    private final RuntimeServices rsvc;
    private final VelocimacroManager vmManager;
    private boolean replaceAllowed = false;
    private boolean addNewAllowed = true;
    private boolean templateLocal = false;
    private boolean blather = false;
    private boolean autoReloadLibrary = false;
    private final List<String> macroLibVec = new CopyOnWriteArrayList<String>();
    private final Map<String, Twonk> libModMap = new HashMap<String, Twonk>();

    public VelocimacroFactory(RuntimeServices rs) {
        this.rsvc = rs;
        this.vmManager = new VelocimacroManager(this.rsvc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initVelocimacro() {
        VelocimacroFactory velocimacroFactory = this;
        synchronized (velocimacroFactory) {
            this.setReplacementPermission(true);
            this.setBlather(true);
            this.logVMMessageInfo("Velocimacro : initialization starting.");
            this.vmManager.setNamespaceUsage(false);
            Object libfiles = this.rsvc.getProperty("velocimacro.library");
            if (libfiles != null) {
                this.macroLibVec.clear();
                if (libfiles instanceof Collection) {
                    Collection files = (Collection)libfiles;
                    this.macroLibVec.addAll(files);
                } else if (libfiles instanceof String) {
                    this.macroLibVec.add((String)libfiles);
                }
                for (int i = 0; i < this.macroLibVec.size(); ++i) {
                    String lib = this.macroLibVec.get(i);
                    if (lib == null || lib.equals("")) continue;
                    this.vmManager.setRegisterFromLib(true);
                    this.logVMMessageInfo("Velocimacro : adding VMs from VM library template : " + lib);
                    try {
                        Template template = this.rsvc.getTemplate(lib);
                        this.libModMap.put(lib, new Twonk(template, template.getLastModified()));
                    }
                    catch (Exception e) {
                        this.logVMMessageInfo("Velocimacro : error using  VM library template " + lib + " : " + e);
                    }
                    this.logVMMessageInfo("Velocimacro :  VM library template macro registration complete.");
                    this.vmManager.setRegisterFromLib(false);
                }
            }
            this.setAddMacroPermission(true);
            if (!this.rsvc.getBoolean("velocimacro.permissions.allow.inline", true)) {
                this.setAddMacroPermission(false);
                this.logVMMessageInfo("Velocimacro : allowInline = false : VMs can not be defined inline in templates");
            } else {
                this.logVMMessageInfo("Velocimacro : allowInline = true : VMs can be defined inline in templates");
            }
            this.setReplacementPermission(false);
            if (this.rsvc.getBoolean("velocimacro.permissions.allow.inline.to.replace.global", false)) {
                this.setReplacementPermission(true);
                this.logVMMessageInfo("Velocimacro : allowInlineToOverride = true : VMs defined inline may replace previous VM definitions");
            } else {
                this.logVMMessageInfo("Velocimacro : allowInlineToOverride = false : VMs defined inline may NOT replace previous VM definitions");
            }
            this.vmManager.setNamespaceUsage(true);
            this.setTemplateLocalInline(this.rsvc.getBoolean("velocimacro.permissions.allow.inline.local.scope", false));
            if (this.getTemplateLocalInline()) {
                this.logVMMessageInfo("Velocimacro : allowInlineLocal = true : VMs defined inline will be local to their defining template only.");
            } else {
                this.logVMMessageInfo("Velocimacro : allowInlineLocal = false : VMs defined inline will be  global in scope if allowed.");
            }
            this.vmManager.setTemplateLocalInlineVM(this.getTemplateLocalInline());
            this.setBlather(this.rsvc.getBoolean("velocimacro.messages.on", true));
            if (this.getBlather()) {
                this.logVMMessageInfo("Velocimacro : messages on  : VM system will output logging messages");
            } else {
                this.logVMMessageInfo("Velocimacro : messages off : VM system will be quiet");
            }
            this.setAutoload(this.rsvc.getBoolean("velocimacro.library.autoreload", false));
            if (this.getAutoload()) {
                this.logVMMessageInfo("Velocimacro : autoload on  : VM system will automatically reload global library macros");
            } else {
                this.logVMMessageInfo("Velocimacro : autoload off  : VM system will not automatically reload global library macros");
            }
            this.rsvc.info("Velocimacro : initialization complete.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addVelocimacro(String name, String macroBody, String[] argArray, String sourceTemplate) {
        if (name == null || macroBody == null || argArray == null || sourceTemplate == null) {
            this.logVMMessageWarn("Velocimacro : VM addition rejected : programmer error : arg null");
            return false;
        }
        if (!this.canAddVelocimacro(name, sourceTemplate)) {
            return false;
        }
        VelocimacroFactory velocimacroFactory = this;
        synchronized (velocimacroFactory) {
            this.vmManager.addVM(name, macroBody, argArray, sourceTemplate);
        }
        if (this.blather) {
            String s = "#" + argArray[0];
            s = s + "(";
            for (int i = 1; i < argArray.length; ++i) {
                s = s + " ";
                s = s + argArray[i];
            }
            s = s + " ) : source = ";
            s = s + sourceTemplate;
            this.logVMMessageInfo("Velocimacro : added new VM : " + s);
        }
        return true;
    }

    private boolean canAddVelocimacro(String name, String sourceTemplate) {
        if (this.getAutoload()) {
            for (int i = 0; i < this.macroLibVec.size(); ++i) {
                String lib = this.macroLibVec.get(i);
                if (!lib.equals(sourceTemplate)) continue;
                return true;
            }
        }
        if (!this.addNewAllowed) {
            this.logVMMessageWarn("Velocimacro : VM addition rejected : " + name + " : inline VMs not allowed.");
            return false;
        }
        if (!this.templateLocal && this.isVelocimacro(name, sourceTemplate) && !this.replaceAllowed) {
            this.logVMMessageWarn("Velocimacro : VM addition rejected : " + name + " : inline not allowed to replace existing VM");
            return false;
        }
        return true;
    }

    private void logVMMessageInfo(String s) {
        if (this.blather) {
            this.rsvc.info(s);
        }
    }

    private void logVMMessageWarn(String s) {
        if (this.blather) {
            this.rsvc.warn(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVelocimacro(String vm, String sourceTemplate) {
        VelocimacroFactory velocimacroFactory = this;
        synchronized (velocimacroFactory) {
            if (this.vmManager.get(vm, sourceTemplate) != null) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directive getVelocimacro(String vmName, String sourceTemplate) {
        VelocimacroProxy vp = null;
        VelocimacroFactory velocimacroFactory = this;
        synchronized (velocimacroFactory) {
            String lib;
            vp = this.vmManager.get(vmName, sourceTemplate);
            if (vp != null && this.getAutoload() && (lib = this.vmManager.getLibraryName(vmName, sourceTemplate)) != null) {
                try {
                    Twonk tw = this.libModMap.get(lib);
                    if (tw != null) {
                        Template template = tw.template;
                        long tt = tw.modificationTime;
                        long ft = template.getResourceLoader().getLastModified(template);
                        if (ft > tt) {
                            this.logVMMessageInfo("Velocimacro : autoload reload for VMs from VM library template : " + lib);
                            tw.modificationTime = ft;
                            tw.template = template = this.rsvc.getTemplate(lib);
                            tw.modificationTime = template.getLastModified();
                        }
                    }
                }
                catch (Exception e) {
                    this.logVMMessageInfo("Velocimacro : error using  VM library template " + lib + " : " + e);
                }
                vp = this.vmManager.get(vmName, sourceTemplate);
            }
        }
        return vp;
    }

    public boolean dumpVMNamespace(String namespace) {
        return this.vmManager.dumpNamespace(namespace);
    }

    private void setTemplateLocalInline(boolean b) {
        this.templateLocal = b;
    }

    private boolean getTemplateLocalInline() {
        return this.templateLocal;
    }

    private boolean setAddMacroPermission(boolean arg) {
        boolean b = this.addNewAllowed;
        this.addNewAllowed = arg;
        return b;
    }

    private boolean setReplacementPermission(boolean arg) {
        boolean b = this.replaceAllowed;
        this.replaceAllowed = arg;
        return b;
    }

    private void setBlather(boolean b) {
        this.blather = b;
    }

    private boolean getBlather() {
        return this.blather;
    }

    private void setAutoload(boolean b) {
        this.autoReloadLibrary = b;
    }

    private boolean getAutoload() {
        return this.autoReloadLibrary;
    }

    private class Twonk {
        volatile Template template;
        volatile long modificationTime;

        Twonk(Template template, long modificationTime) {
            this.template = template;
            this.modificationTime = modificationTime;
        }
    }
}

