/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.web.bean.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PagerFilter<T>
implements Serializable {
    private static final int PAGES_TO_LIST = 5;
    private int max = 20;
    private int start = 0;
    protected Collection<Page> pages;

    public PagerFilter() {
    }

    public PagerFilter(PagerFilter old) {
        this.setMax(old.getMax());
        this.setStart(old.getStart());
    }

    public PagerFilter(int max) {
        this.max = max == -1 ? Integer.MAX_VALUE : max;
    }

    public PagerFilter(int start, int max) {
        this(max);
        this.setStart(start);
    }

    public static PagerFilter getUnlimitedFilter() {
        return new PagerFilter(Integer.MAX_VALUE);
    }

    public static PagerFilter newPageAlignedFilter(int index, int max) {
        if (index < 0) {
            throw new IllegalArgumentException(String.format("index %d is less than 0.", index));
        }
        return new PagerFilter(index - index % max, max);
    }

    public List<T> getCurrentPage(List<T> itemsCol) {
        List<T> items = itemsCol == null ? new ArrayList<T>() : itemsCol;
        if (items.isEmpty()) {
            this.start = 0;
            return Collections.emptyList();
        }
        if (this.start >= items.size()) {
            this.start = 0;
            return items.subList(0, Math.min(this.max, items.size()));
        }
        return items.subList(this.start, Math.min(this.start + this.max, items.size()));
    }

    public List<Page> getPages(Collection<T> itemsCol) {
        if (this.pages == null) {
            this.pages = this.generatePages(itemsCol);
        }
        return this.restrictPages(this.pages, itemsCol.size());
    }

    protected Collection<Page> getPages() {
        return this.pages;
    }

    public List<Page> generatePages(Collection<T> items) {
        if (items == null || items.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Page> pages = new ArrayList<Page>();
        int total = items.size();
        int pageNumber = 1;
        for (int index = 0; index < total; index += this.max) {
            pages.add(new Page(index, pageNumber, this));
            ++pageNumber;
        }
        return Collections.unmodifiableList(pages);
    }

    public List<Page> restrictPages(Collection<Page> pages, int size) {
        ArrayList<Page> pagesToDisplay = new ArrayList<Page>(10);
        int firstpage = 1;
        int lastpage = firstpage + 5 + 5 - 2;
        int maxpage = (size + this.max - 1) / this.max;
        if (lastpage < maxpage) {
            int ourpage = this.getStart() / this.max + 1;
            if (ourpage - firstpage > 4) {
                lastpage = ourpage + 5 - 1;
                if (lastpage > maxpage) {
                    lastpage = maxpage;
                }
                firstpage = lastpage - 5 - 5 + 2;
            }
        } else if (lastpage > maxpage) {
            lastpage = maxpage;
        }
        int minstart = (firstpage - 1) * this.max;
        int maxstart = (lastpage - 1) * this.max;
        for (Page page : pages) {
            boolean smallerThanMax;
            if (page.getStart() > size) continue;
            boolean largerThanMin = page.getStart() >= minstart;
            boolean bl = smallerThanMax = page.getStart() <= maxstart;
            if (!largerThanMin || !smallerThanMax) continue;
            pagesToDisplay.add(page);
        }
        return Collections.unmodifiableList(pagesToDisplay);
    }

    public int getMax() {
        return this.max;
    }

    public int getPageSize() {
        return this.getMax();
    }

    public void setMax(int max) {
        if (this.max != max) {
            this.pages = null;
        }
        this.max = max;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return Math.max(this.start + this.max, this.max);
    }

    public int getNextStart() {
        return Math.max(this.start + this.max, this.max);
    }

    public int getPreviousStart() {
        return Math.max(0, this.start - this.max);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("start", this.getStart()).append("end", this.getEnd()).append("max", this.getMax()).toString();
    }
}

