/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.query.membership;

import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipQuery<T>
implements Query<T> {
    private final EntityDescriptor entityToReturn;
    private final EntityDescriptor entityToMatch;
    private final boolean findChildren;
    private final String entityNameToMatch;
    private final int startIndex;
    private final int maxResults;
    private Class<T> returnType;

    public MembershipQuery(Class<T> returnType, boolean findChildren, EntityDescriptor entityToMatch, String entityNameToMatch, EntityDescriptor entityToReturn, int startIndex, int maxResults) {
        Validate.notNull((Object)entityToMatch, (String)"entityToMatch argument cannot be null");
        Validate.notNull((Object)entityNameToMatch, (String)"entityNameToMatch argument cannot be null");
        Validate.notNull((Object)entityToReturn, (String)"entityToReturn argument cannot be null");
        Validate.isTrue((maxResults == -1 || maxResults > 0 ? 1 : 0) != 0, (String)"maxResults must be greater than 0 (unless set to EntityQuery.ALL_RESULTS)");
        Validate.isTrue((startIndex >= 0 ? 1 : 0) != 0, (String)"startIndex cannot be less than zero");
        Validate.notNull(returnType, (String)"returnType cannot be null");
        if (findChildren) {
            Validate.isTrue((entityToMatch.getEntityType() == Entity.GROUP ? 1 : 0) != 0, (String)("Cannot find the children of type: " + entityToMatch));
        } else {
            Validate.isTrue((entityToReturn.getEntityType() == Entity.GROUP ? 1 : 0) != 0, (String)("Cannot return parents of type: " + entityToMatch));
        }
        this.entityToReturn = entityToReturn;
        this.entityToMatch = entityToMatch;
        this.findChildren = findChildren;
        this.entityNameToMatch = entityNameToMatch;
        this.startIndex = startIndex;
        this.maxResults = maxResults;
        this.returnType = returnType;
    }

    public MembershipQuery(MembershipQuery<T> query, int startIndex, int maxResults) {
        this(query.getReturnType(), query.isFindChildren(), query.getEntityToMatch(), query.getEntityNameToMatch(), query.getEntityToReturn(), startIndex, maxResults);
    }

    public MembershipQuery(MembershipQuery query, Class<T> returnType) {
        this(returnType, query.isFindChildren(), query.getEntityToMatch(), query.getEntityNameToMatch(), query.getEntityToReturn(), query.getStartIndex(), query.getMaxResults());
    }

    public EntityDescriptor getEntityToReturn() {
        return this.entityToReturn;
    }

    public EntityDescriptor getEntityToMatch() {
        return this.entityToMatch;
    }

    public boolean isFindChildren() {
        return this.findChildren;
    }

    public String getEntityNameToMatch() {
        return this.entityNameToMatch;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Class<T> getReturnType() {
        return this.returnType;
    }

    public SearchRestriction getSearchRestriction() {
        return NullRestrictionImpl.INSTANCE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MembershipQuery)) {
            return false;
        }
        MembershipQuery that = (MembershipQuery)o;
        if (this.findChildren != that.findChildren) {
            return false;
        }
        if (this.maxResults != that.maxResults) {
            return false;
        }
        if (this.startIndex != that.startIndex) {
            return false;
        }
        if (this.entityNameToMatch != null ? !this.entityNameToMatch.equals(that.entityNameToMatch) : that.entityNameToMatch != null) {
            return false;
        }
        if (this.entityToMatch != null ? !this.entityToMatch.equals(that.entityToMatch) : that.entityToMatch != null) {
            return false;
        }
        if (this.entityToReturn != null ? !this.entityToReturn.equals(that.entityToReturn) : that.entityToReturn != null) {
            return false;
        }
        return this.returnType == that.returnType;
    }

    public int hashCode() {
        int result = this.entityToReturn != null ? this.entityToReturn.hashCode() : 0;
        result = 31 * result + (this.entityToMatch != null ? this.entityToMatch.hashCode() : 0);
        result = 31 * result + (this.findChildren ? 1 : 0);
        result = 31 * result + (this.entityNameToMatch != null ? this.entityNameToMatch.hashCode() : 0);
        result = 31 * result + this.startIndex;
        result = 31 * result + this.maxResults;
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("entityToReturn", (Object)this.entityToReturn).append("entityToMatch", (Object)this.entityToMatch).append("findChildren", this.findChildren).append("entityNameToMatch", (Object)this.entityNameToMatch).append("startIndex", this.startIndex).append("maxResults", this.maxResults).toString();
    }
}

