/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;

public class UtilCache<K, V> {
    public static Map<String, UtilCache<?, ?>> utilCacheTable = new HashMap();
    protected static Map<String, Integer> defaultIndices = new HashMap<String, Integer>();
    protected String name;
    public LinkedList<K> keyLRUList = new LinkedList();
    public Map<K, CacheLine<V>> cacheLineTable = new HashMap<K, CacheLine<V>>();
    protected long hitCount = 0L;
    protected long missCount = 0L;
    protected long maxSize = 0L;
    protected long expireTime = 0L;
    protected boolean useSoftReference = false;

    public UtilCache(String cacheName, long maxSize, long expireTime, boolean useSoftReference) {
        this.useSoftReference = useSoftReference;
        this.maxSize = maxSize;
        this.expireTime = expireTime;
        this.setPropertiesParams(cacheName);
        this.name = cacheName + this.getNextDefaultIndex(cacheName);
        utilCacheTable.put(this.name, this);
    }

    public UtilCache(String cacheName, long maxSize, long expireTime) {
        this(cacheName, maxSize, expireTime, false);
    }

    public UtilCache(long maxSize, long expireTime) {
        this.useSoftReference = false;
        this.maxSize = maxSize;
        this.expireTime = expireTime;
        String name = "specified" + this.getNextDefaultIndex("specified");
        this.setPropertiesParams(name);
        utilCacheTable.put(name, this);
    }

    public UtilCache(String cacheName) {
        this.setPropertiesParams("default");
        this.setPropertiesParams(cacheName);
        this.name = cacheName + this.getNextDefaultIndex(cacheName);
        utilCacheTable.put(this.name, this);
    }

    public UtilCache() {
        this.setPropertiesParams("default");
        this.name = "default" + this.getNextDefaultIndex("default");
        utilCacheTable.put(this.name, this);
    }

    protected String getNextDefaultIndex(String cacheName) {
        Integer curInd = defaultIndices.get(cacheName);
        if (curInd == null) {
            defaultIndices.put(cacheName, 1);
            return "";
        }
        defaultIndices.put(cacheName, curInd + 1);
        return Integer.toString(curInd + 1);
    }

    protected void setPropertiesParams(String cacheName) {
        ResourceBundle res = ResourceBundle.getBundle("cache");
        if (res != null) {
            Long longValue;
            String value;
            try {
                value = res.getString(cacheName + ".maxSize");
                longValue = new Long(value);
                if (longValue != null) {
                    this.maxSize = longValue;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                value = res.getString(cacheName + ".expireTime");
                longValue = new Long(value);
                if (longValue != null) {
                    this.expireTime = longValue;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                value = res.getString(cacheName + ".useSoftReference");
                if (value != null) {
                    this.useSoftReference = "true".equals(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void put(K key, V value) {
        if (key == null) {
            return;
        }
        if (this.maxSize > 0L) {
            if (this.cacheLineTable.containsKey(key)) {
                this.keyLRUList.remove(key);
                this.keyLRUList.addFirst(key);
            } else {
                this.keyLRUList.addFirst(key);
            }
        }
        if (this.expireTime > 0L) {
            this.cacheLineTable.put(key, new CacheLine<V>(value, this.useSoftReference, System.currentTimeMillis()));
        } else {
            this.cacheLineTable.put(key, new CacheLine<V>(value, this.useSoftReference));
        }
        if (this.maxSize > 0L && (long)this.cacheLineTable.size() > this.maxSize) {
            K lastKey = this.keyLRUList.getLast();
            this.remove(lastKey);
        }
    }

    public V get(K key) {
        if (key == null) {
            ++this.missCount;
            return null;
        }
        CacheLine<V> line = this.cacheLineTable.get(key);
        if (this.hasExpired(line)) {
            this.remove(key);
            line = null;
        }
        if (line == null) {
            ++this.missCount;
            return null;
        }
        ++this.hitCount;
        if (this.maxSize > 0L) {
            this.keyLRUList.remove(key);
            this.keyLRUList.addFirst(key);
        }
        return line.getValue();
    }

    public synchronized Object remove(Object key) {
        if (key == null) {
            ++this.missCount;
            return null;
        }
        CacheLine<V> line = this.cacheLineTable.remove(key);
        if (line != null) {
            if (this.maxSize > 0L) {
                this.keyLRUList.remove(key);
            }
            return line.getValue();
        }
        ++this.missCount;
        return null;
    }

    public synchronized void clear() {
        this.cacheLineTable.clear();
        this.keyLRUList.clear();
        this.clearCounters();
    }

    public static void clearAllCaches() {
        for (Map.Entry<String, UtilCache<?, ?>> entry : utilCacheTable.entrySet()) {
            entry.getValue().clear();
        }
    }

    public String getName() {
        return this.name;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public void clearCounters() {
        this.hitCount = 0L;
        this.missCount = 0L;
    }

    public void setMaxSize(long maxSize) {
        if (maxSize <= 0L) {
            this.keyLRUList.clear();
        } else if (maxSize > 0L && this.maxSize <= 0L) {
            for (K key : this.cacheLineTable.keySet()) {
                this.keyLRUList.add(key);
            }
        }
        if (maxSize > 0L && (long)this.cacheLineTable.size() > maxSize) {
            while ((long)this.cacheLineTable.size() > maxSize) {
                K lastKey = this.keyLRUList.getLast();
                this.remove(lastKey);
            }
        }
        this.maxSize = maxSize;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setExpireTime(long expireTime) {
        if (this.expireTime <= 0L && expireTime > 0L) {
            long currentTime = System.currentTimeMillis();
            for (CacheLine<V> vCacheLine : this.cacheLineTable.values()) {
                vCacheLine.loadTime = currentTime;
            }
        } else if (this.expireTime > 0L || expireTime > 0L) {
            // empty if block
        }
        this.expireTime = expireTime;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public void setUseSoftReference(boolean useSoftReference) {
        if (this.useSoftReference != useSoftReference) {
            this.useSoftReference = useSoftReference;
            for (CacheLine<V> vCacheLine : this.cacheLineTable.values()) {
                vCacheLine.setUseSoftReference(useSoftReference);
            }
        }
    }

    public boolean getUseSoftReference() {
        return this.useSoftReference;
    }

    public long size() {
        return this.cacheLineTable.size();
    }

    public boolean containsKey(Object key) {
        CacheLine<V> line = this.cacheLineTable.get(key);
        if (this.hasExpired(line)) {
            this.remove(key);
            line = null;
        }
        return line != null;
    }

    public boolean hasExpired(K key) {
        if (key == null) {
            return false;
        }
        CacheLine<V> line = this.cacheLineTable.get(key);
        return this.hasExpired(line);
    }

    protected boolean hasExpired(CacheLine<V> line) {
        if (line == null) {
            return false;
        }
        if (this.useSoftReference && line.getValue() == null) {
            return true;
        }
        if (this.expireTime <= 0L) {
            return false;
        }
        if (line.loadTime <= 0L) {
            return true;
        }
        return line.loadTime + this.expireTime < System.currentTimeMillis();
    }

    public void clearExpired() {
        for (K k : this.cacheLineTable.keySet()) {
            if (!this.hasExpired(k)) continue;
            this.remove(k);
        }
    }

    public static void clearExpiredFromAllCaches() {
        for (Map.Entry<String, UtilCache<?, ?>> entry : utilCacheTable.entrySet()) {
            entry.getValue().clearExpired();
        }
    }

    public static boolean validKey(String cacheName, Object key) {
        UtilCache<?, ?> cache = utilCacheTable.get(cacheName);
        return cache != null && cache.containsKey(key);
    }

    public static class CacheLine<T> {
        public Object valueRef = null;
        public long loadTime = 0L;
        public boolean useSoftReference = false;

        public CacheLine(T value, boolean useSoftReference) {
            this.valueRef = useSoftReference ? new SoftReference<T>(value) : value;
            this.useSoftReference = useSoftReference;
        }

        public CacheLine(T value, boolean useSoftReference, long loadTime) {
            this(value, useSoftReference);
            this.loadTime = loadTime;
        }

        public T getValue() {
            if (this.valueRef == null) {
                return null;
            }
            if (this.useSoftReference) {
                return ((SoftReference)this.valueRef).get();
            }
            return (T)this.valueRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setUseSoftReference(boolean useSoftReference) {
            if (this.useSoftReference != useSoftReference) {
                CacheLine cacheLine = this;
                synchronized (cacheLine) {
                    this.useSoftReference = useSoftReference;
                    this.valueRef = useSoftReference ? new SoftReference<Object>(this.valueRef) : ((SoftReference)this.valueRef).get();
                }
            }
        }
    }
}

