/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceLoader;

public class UrlLoader
extends ResourceLoader {
    @Override
    public InputStream loadResource(String location) throws GenericConfigException {
        String fullLocation = this.fullLocation(location);
        URL url = null;
        try {
            url = new URL(fullLocation);
        }
        catch (MalformedURLException e) {
            throw new GenericConfigException("Error with malformed URL while trying to load URL resource at location [" + fullLocation + "]", e);
        }
        if (url == null) {
            throw new GenericConfigException("URL Resource not found: " + fullLocation);
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new GenericConfigException("Error opening URL resource at location [" + url.toExternalForm() + "]", e);
        }
    }
}

