/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gzipfilter.org.tuckey.web.filters.urlrewrite;

import com.atlassian.gzipfilter.org.tuckey.web.filters.urlrewrite.ConditionMatch;
import com.atlassian.gzipfilter.org.tuckey.web.filters.urlrewrite.utils.Log;
import com.atlassian.gzipfilter.org.tuckey.web.filters.urlrewrite.utils.StringMatchingMatcher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BackReferenceReplacer {
    private static Log log = Log.getLog(class$org$tuckey$web$filters$urlrewrite$BackReferenceReplacer == null ? (class$org$tuckey$web$filters$urlrewrite$BackReferenceReplacer = BackReferenceReplacer.class$("com.atlassian.gzipfilter.org.tuckey.web.filters.urlrewrite.BackReferenceReplacer")) : class$org$tuckey$web$filters$urlrewrite$BackReferenceReplacer);
    private static Pattern backRefPattern = Pattern.compile("(?<!\\\\)%([0-9])");
    private static Pattern escapedBackRefPattern = Pattern.compile("\\\\(%[0-9])");
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$BackReferenceReplacer;

    public static boolean containsBackRef(String to) {
        Matcher backRefMatcher = backRefPattern.matcher(to);
        return backRefMatcher.find();
    }

    public static String replace(ConditionMatch lastConditionMatch, String subjectOfReplacement) {
        int lastCondMatcherGroupCount;
        if (lastConditionMatch == null) {
            return subjectOfReplacement;
        }
        StringMatchingMatcher lastConditionMatchMatcher = lastConditionMatch.getMatcher();
        if (lastConditionMatchMatcher != null && (lastCondMatcherGroupCount = lastConditionMatchMatcher.groupCount()) > 0) {
            Matcher backRefMatcher = backRefPattern.matcher(subjectOfReplacement);
            StringBuffer sb = new StringBuffer();
            boolean anyMatches = false;
            while (backRefMatcher.find()) {
                anyMatches = true;
                int groupCount = backRefMatcher.groupCount();
                if (groupCount < 1) {
                    log.error("group count on backref finder regex is not as expected");
                    if (!log.isDebugEnabled()) continue;
                    log.error("backRefMatcher: " + backRefMatcher.toString());
                    continue;
                }
                String varStr = backRefMatcher.group(1);
                boolean validBackref = false;
                int varInt = 0;
                log.debug("found " + varStr);
                try {
                    varInt = Integer.parseInt(varStr);
                    if (varInt > lastCondMatcherGroupCount) {
                        log.error("backref %" + varInt + " not found in conditon ");
                        if (log.isDebugEnabled()) {
                            log.debug("condition matcher: " + lastConditionMatchMatcher.toString());
                        }
                    } else {
                        validBackref = true;
                    }
                }
                catch (NumberFormatException nfe) {
                    log.error("could not parse backref " + varStr + " to number");
                }
                String conditionMatch = "";
                if (validBackref) {
                    conditionMatch = lastConditionMatchMatcher.group(varInt);
                }
                backRefMatcher.appendReplacement(sb, conditionMatch);
            }
            if (anyMatches) {
                backRefMatcher.appendTail(sb);
                if (log.isDebugEnabled()) {
                    log.debug("replaced sb is " + sb);
                }
                subjectOfReplacement = sb.toString();
            }
        }
        Matcher escapedVariableMatcher = escapedBackRefPattern.matcher(subjectOfReplacement);
        subjectOfReplacement = escapedVariableMatcher.replaceAll("$1");
        return subjectOfReplacement;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

