/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.config;

import java.sql.Connection;
import java.util.Properties;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericHelperDAO;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.config.JdbcDatasourceInfo;
import org.ofbiz.core.entity.config.JndiDatasourceInfo;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;
import org.ofbiz.core.entity.util.ClassLoaderUtils;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.GeneralRuntimeException;
import org.ofbiz.core.util.UtilValidate;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;

public class DatasourceInfo {
    private final String name;
    private final String helperClass;
    private String fieldTypeName;
    private JndiDatasourceInfo jndiDatasource;
    private Element tyrexDataSourceElement;
    private JdbcDatasourceInfo jdbcDatasource;
    private String schemaName = null;
    private boolean checkOnStart = true;
    private boolean addMissingOnStart = true;
    private boolean useFks = false;
    private boolean useFkIndices = false;
    private boolean checkForeignKeysOnStart = false;
    private boolean checkFkIndicesOnStart = false;
    private boolean usePkConstraintNames = true;
    private String constraintNameClipLengthStr;
    private Integer constraintNameClipLength = null;
    private String fkStyle = null;
    private boolean useFkInitiallyDeferred = true;
    private boolean useIndices = true;
    private String joinStyle = "ansi";
    protected static final Properties CONFIGURATION = new Properties();
    public static final String AUTO_FIELD_TYPE;
    public static final String AUTO_SCHEMA_NAME;
    public static final String AUTO_CONSTRAINT_NAME_CLIP_LENGTH;
    public static final int DEFAULT_CONSTRAINT_NAME_CLIP_LENGTH = 20;

    private static String getNonNullProperty(String propertyKey, String defaultValue) {
        String fieldValue = CONFIGURATION.getProperty(propertyKey);
        if (fieldValue != null) {
            return fieldValue;
        }
        Debug.logError((String)(propertyKey + " not set in the ofbiz-database.properties file. Using default value: " + defaultValue));
        return defaultValue;
    }

    public DatasourceInfo(String name, String fieldTypeName, String schemaName, JdbcDatasourceInfo jdbcDatasource) {
        this.name = name;
        this.fieldTypeName = fieldTypeName;
        this.helperClass = GenericHelperDAO.class.getName();
        this.jdbcDatasource = jdbcDatasource;
        this.schemaName = schemaName;
    }

    public DatasourceInfo(String name, String fieldTypeName, String schemaName, JndiDatasourceInfo jndiDatasource) {
        this.name = name;
        this.fieldTypeName = fieldTypeName;
        this.helperClass = GenericHelperDAO.class.getName();
        this.jndiDatasource = jndiDatasource;
        this.schemaName = schemaName;
    }

    public DatasourceInfo(Element element) {
        Element jdbcDatasourceElement;
        Element jndiDatasourceElement;
        this.name = element.getAttribute("name");
        this.helperClass = element.getAttribute("helper-class");
        this.fieldTypeName = element.getAttribute("field-type-name");
        this.schemaName = element.getAttribute("schema-name");
        this.checkOnStart = !"false".equals(element.getAttribute("check-on-start"));
        this.addMissingOnStart = "true".equals(element.getAttribute("add-missing-on-start"));
        this.useFks = !"false".equals(element.getAttribute("use-foreign-keys"));
        this.useFkIndices = !"false".equals(element.getAttribute("use-foreign-key-indices"));
        this.checkForeignKeysOnStart = "true".equals(element.getAttribute("check-fks-on-start"));
        this.checkFkIndicesOnStart = "true".equals(element.getAttribute("check-fk-indices-on-start"));
        this.usePkConstraintNames = !"false".equals(element.getAttribute("use-pk-constraint-names"));
        this.constraintNameClipLengthStr = element.getAttribute("constraint-name-clip-length");
        this.fkStyle = element.getAttribute("fk-style");
        this.useFkInitiallyDeferred = "true".equals(element.getAttribute("use-fk-initially-deferred"));
        this.useIndices = !"false".equals(element.getAttribute("use-indices"));
        this.joinStyle = element.getAttribute("join-style");
        if (this.fkStyle == null || this.fkStyle.length() == 0) {
            this.fkStyle = "name_constraint";
        }
        if (this.joinStyle == null || this.joinStyle.length() == 0) {
            this.joinStyle = "ansi";
        }
        if ((jndiDatasourceElement = UtilXml.firstChildElement((Element)element, (String)"jndi-jdbc")) != null) {
            String jndiName = jndiDatasourceElement.getAttribute("jndi-name");
            String jndiServerName = jndiDatasourceElement.getAttribute("jndi-server-name");
            this.jndiDatasource = new JndiDatasourceInfo(jndiName, jndiServerName);
        }
        if ((jdbcDatasourceElement = UtilXml.firstChildElement((Element)element, (String)"inline-jdbc")) != null) {
            String uri = jdbcDatasourceElement.getAttribute("jdbc-uri");
            String driverClassName = jdbcDatasourceElement.getAttribute("jdbc-driver");
            String username = jdbcDatasourceElement.getAttribute("jdbc-username");
            String password = jdbcDatasourceElement.getAttribute("jdbc-password");
            String transIso = jdbcDatasourceElement.getAttribute("isolation-level");
            int maxSize = this.getIntValueFromElement(jdbcDatasourceElement, "pool-maxsize", 50);
            int minSize = this.getIntValueFromElement(jdbcDatasourceElement, "pool-minsize", 2);
            long maxWait = this.getLongValueFromElement(jdbcDatasourceElement, "pool-maxwait", 60000L);
            long sleepTime = this.getLongValueFromElement(jdbcDatasourceElement, "pool-sleeptime", 300000L);
            long lifeTime = this.getLongValueFromElement(jdbcDatasourceElement, "pool-lifetime", 600000L);
            long deadLockMaxWait = this.getLongValueFromElement(jdbcDatasourceElement, "pool-deadlock-maxwait", 300000L);
            long deadLockRetryWait = this.getLongValueFromElement(jdbcDatasourceElement, "pool-deadlock-retrywait", 10000L);
            String validationQuery = jdbcDatasourceElement.getAttribute("pool-validationQuery");
            Long minEvictableTimeMillis = this.getLongValueFromElement(jdbcDatasourceElement, "pool-minEvictableIdleTimeMillis", null);
            Long timeBetweenEvictionRunsMillis = this.getLongValueFromElement(jdbcDatasourceElement, "pool-timeBetweenEvictionRunsMillis", null);
            Properties connectionProperties = this.parsePropertyString(jdbcDatasourceElement.getAttribute("jdbc-connectionProperties"));
            ConnectionPoolInfo connectionPoolInfo = new ConnectionPoolInfo(maxSize, minSize, maxWait, sleepTime, lifeTime, deadLockMaxWait, deadLockRetryWait, validationQuery, minEvictableTimeMillis, timeBetweenEvictionRunsMillis);
            this.jdbcDatasource = new JdbcDatasourceInfo(uri, driverClassName, username, password, transIso, connectionProperties, connectionPoolInfo);
        }
        this.tyrexDataSourceElement = UtilXml.firstChildElement((Element)element, (String)"tyrex-dataSource");
    }

    private int getIntValueFromElement(Element element, String attributeName, int defaultValue) {
        String value = element.getAttribute(attributeName);
        if (value == null) {
            Debug.logInfo((String)(attributeName + " not set, defaulting to " + defaultValue));
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            Debug.logError((String)(attributeName + " was not a number, but was \"" + value + "\", defaulting to " + defaultValue));
            return defaultValue;
        }
    }

    private Long getLongValueFromElement(Element element, String attributeName, Long defaultValue) {
        String value = element.getAttribute(attributeName);
        if (value == null) {
            Debug.logInfo((String)(attributeName + " not set, defaulting to " + defaultValue));
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            Debug.logError((String)(attributeName + " was not a number, but was \"" + value + "\", defaulting to " + defaultValue));
            return defaultValue;
        }
    }

    private Properties parsePropertyString(String propertiesString) {
        if (UtilValidate.isEmpty((String)propertiesString)) {
            return null;
        }
        Properties properties = new Properties();
        for (String keyValue : propertiesString.split(";")) {
            String[] values = keyValue.split("=");
            if (values.length != 2) {
                Debug.logError((String)("Bad property format (must be name=value): " + keyValue), (String)DatasourceInfo.class.getName());
            }
            properties.setProperty(values[0], values[1]);
        }
        return properties;
    }

    public String getFieldTypeName() {
        if (AUTO_FIELD_TYPE.equals(this.fieldTypeName)) {
            this.fieldTypeName = this.findFieldTypeFromJDBCConnection();
        }
        return this.fieldTypeName;
    }

    public String getSchemaName() {
        if (AUTO_SCHEMA_NAME.equals(this.schemaName)) {
            this.schemaName = this.findSchemaNameFromJDBCConnection();
        }
        return this.schemaName;
    }

    public int getConstraintNameClipLength() {
        if (this.constraintNameClipLength == null) {
            if (AUTO_CONSTRAINT_NAME_CLIP_LENGTH.equals(this.constraintNameClipLengthStr)) {
                this.constraintNameClipLength = this.findConstraintNameClipLengthFromJDBCConnection();
            } else {
                try {
                    this.constraintNameClipLength = 30;
                    if (this.constraintNameClipLengthStr != null && !this.constraintNameClipLengthStr.equals("")) {
                        this.constraintNameClipLength = new Integer(this.constraintNameClipLengthStr);
                    }
                }
                catch (Exception e) {
                    Debug.logError((String)("Could not parse constraint-name-clip-length value for datasource with name " + this.name + ", using default value of 30"));
                }
            }
        }
        return this.constraintNameClipLength;
    }

    private String findFieldTypeFromJDBCConnection() {
        try {
            Connection connection = ConnectionFactory.getConnection(this.name);
            DatabaseType typeForConnection = DatabaseTypeFactory.getTypeForConnection(connection);
            if (typeForConnection == null) {
                Debug.logError((String)"Could not determine database type from ");
            }
            return typeForConnection.getFieldTypeName();
        }
        catch (Exception e) {
            String error = "Could not get connection to database to determine database type for " + AUTO_FIELD_TYPE;
            Debug.logError((Throwable)e, (String)error);
            throw new GeneralRuntimeException(error, (Throwable)e);
        }
    }

    private String findSchemaNameFromJDBCConnection() {
        try {
            Connection connection = ConnectionFactory.getConnection(this.name);
            DatabaseType typeForConnection = DatabaseTypeFactory.getTypeForConnection(connection);
            if (typeForConnection == null) {
                Debug.logError((String)"Could not determine database type from ");
            }
            return typeForConnection.getSchemaName(connection);
        }
        catch (Exception e) {
            String error = "Could not get connection to database to determine database schema-name for " + AUTO_SCHEMA_NAME;
            Debug.logError((Throwable)e, (String)error);
            throw new GeneralRuntimeException(error, (Throwable)e);
        }
    }

    private int findConstraintNameClipLengthFromJDBCConnection() {
        try {
            Connection connection = ConnectionFactory.getConnection(this.name);
            DatabaseType typeForConnection = DatabaseTypeFactory.getTypeForConnection(connection);
            if (typeForConnection == null) {
                Debug.logError((String)"Could not determine database type from ");
            }
            return typeForConnection.getConstraintNameClipLength();
        }
        catch (Exception e) {
            String error = "Could not get connection to database to determine database clip length";
            Debug.logError((Throwable)e, (String)error);
            return 20;
        }
    }

    public JndiDatasourceInfo getJndiDatasource() {
        return this.jndiDatasource;
    }

    public String getName() {
        return this.name;
    }

    public String getHelperClass() {
        return this.helperClass;
    }

    public Element getTyrexDataSourceElement() {
        return this.tyrexDataSourceElement;
    }

    public JdbcDatasourceInfo getJdbcDatasource() {
        return this.jdbcDatasource;
    }

    public boolean isCheckOnStart() {
        return this.checkOnStart;
    }

    public boolean isAddMissingOnStart() {
        return this.addMissingOnStart;
    }

    public boolean isUseFks() {
        return this.useFks;
    }

    public boolean isUseFkIndices() {
        return this.useFkIndices;
    }

    public boolean isCheckForeignKeysOnStart() {
        return this.checkForeignKeysOnStart;
    }

    public boolean isCheckFkIndicesOnStart() {
        return this.checkFkIndicesOnStart;
    }

    public boolean isUsePkConstraintNames() {
        return this.usePkConstraintNames;
    }

    public String getFkStyle() {
        return this.fkStyle;
    }

    public boolean isUseFkInitiallyDeferred() {
        return this.useFkInitiallyDeferred;
    }

    public boolean isUseIndices() {
        return this.useIndices;
    }

    public String getJoinStyle() {
        return this.joinStyle;
    }

    static {
        try {
            CONFIGURATION.load(ClassLoaderUtils.getResourceAsStream("ofbiz-database.properties", EntityConfigUtil.class));
        }
        catch (Exception e) {
            Debug.logError((String)"Unable to find ofbiz-database.properties file. Using default values for ofbiz configuration.");
        }
        AUTO_FIELD_TYPE = DatasourceInfo.getNonNullProperty("fieldType.autoConfigue", "${auto-field-type-name}");
        AUTO_SCHEMA_NAME = DatasourceInfo.getNonNullProperty("schemaName.autoConfigure", "${auto-schema-name}");
        AUTO_CONSTRAINT_NAME_CLIP_LENGTH = DatasourceInfo.getNonNullProperty("constraintNameClipLength.autoConfigure", "${auto-constraint-name-clip-length}");
    }
}

