/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.substitute;

import electric.xml.Attribute;
import electric.xml.Attributes;
import electric.xml.Element;
import electric.xml.IXMLConstants;
import electric.xml.Node;
import electric.xml.NodeWriter;
import electric.xml.Text;
import electric.xml.substitute.TagData;
import java.io.IOException;
import java.io.Writer;

public final class SubstituteWriter
extends NodeWriter
implements IXMLConstants {
    private TagData tagData;

    public SubstituteWriter(Writer writer, int indent, boolean expandEmptyElements, TagData tagData) {
        super(writer, indent, expandEmptyElements);
        this.tagData = tagData;
    }

    public void write(Node node) throws IOException {
        if (node instanceof Element) {
            this.writeElement((Element)node);
        } else if (node instanceof Attribute) {
            this.writeAttribute((Attribute)node);
        } else {
            super.write(node);
        }
    }

    private void writeElement(Element element) throws IOException {
        String prefix;
        this.writeIndent();
        this.write('<');
        String name = element.getName();
        String substituteName = this.tagData.getCode(name);
        if (substituteName != null) {
            name = substituteName;
        }
        if ((prefix = element.getPrefix()) != null && !prefix.equals("")) {
            String substitutePrefix = this.tagData.getCode(prefix);
            if (substitutePrefix != null) {
                prefix = substitutePrefix;
            }
            this.write(prefix);
            this.write(':');
        }
        this.write(name);
        Attributes attributes = element.getAttributeObjects();
        while (attributes.hasMoreElements()) {
            this.write(' ');
            this.write(attributes.next());
        }
        if (!element.hasChildren()) {
            this.write("/>");
        } else {
            this.write('>');
            element.writeChildren(this);
            this.write("</");
            if (prefix != null && !prefix.equals("")) {
                this.write(prefix);
                this.write(':');
            }
            this.write(name);
            this.write('>');
        }
    }

    private void writeAttribute(Attribute attribute) throws IOException {
        String prefix;
        String name = attribute.getLocalName();
        String substituteName = this.tagData.getCode(name);
        if (substituteName != null) {
            name = substituteName;
        }
        if ((prefix = attribute.getPrefix()) != null) {
            String substitutePrefix = this.tagData.getCode(prefix);
            if (substitutePrefix != null) {
                prefix = substitutePrefix;
            }
            this.write(prefix);
            this.write(':');
        }
        this.write(name);
        this.write("='");
        String value = attribute.getValue();
        if (value == null) {
            this.write("null");
        } else if (attribute.getRaw()) {
            this.write(value);
        } else {
            Text.writeWithSubstitution(this, value);
        }
        this.write('\'');
    }
}

