/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.model;

import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.util.java.JavaSource;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.complex.any.AnyHandler;
import electric.xml.io.model.All;
import electric.xml.io.model.Group;
import electric.xml.io.model.IModel;
import electric.xml.io.model.Sequence;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaAttribute;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;

public class Choice
extends Type
implements IModel {
    private IModel[] models = new IModel[0];
    private SchemaElement[] elements = new SchemaElement[0];
    private Type parentType;
    private AnyHandler anyHandler;

    public Choice(Type parentType, Element schemaElement) throws SchemaException {
        this.setParentType(parentType);
        this.readSchema(schemaElement);
    }

    public Choice(Schema schema, Element schemaElement) throws SchemaException {
        this.setSchema(schema);
        this.readSchema(schemaElement);
    }

    public void readSchema(Element schemaElement) throws SchemaException {
        Elements elements = schemaElement.getElements();
        while (elements.hasMoreElements()) {
            Element child = elements.next();
            if (this.parentType != null) {
                if (child.getName().equals("all")) {
                    this.addModel(new All(this.parentType, child));
                    continue;
                }
                if (child.getName().equals("annotation")) continue;
                if (child.getName().equals("any")) {
                    this.anyHandler = new AnyHandler(child, this.parentType);
                    continue;
                }
                if (child.getName().equals("choice")) {
                    this.addModel(new Choice(this.parentType, child));
                    continue;
                }
                if (child.getName().equals("group")) {
                    this.addModel(new Group(this.parentType, child));
                    continue;
                }
                if (child.getName().equals("element")) {
                    this.addElement(new SchemaElement(this.parentType, child));
                    continue;
                }
                if (child.getName().equals("sequence")) {
                    this.addModel(new Sequence(this.parentType, child));
                    continue;
                }
                throw new SchemaException("<choice> in type " + this.parentType.getQName() + " must currently be followed by <sequence>, <all>, or <annotation>");
            }
            if (child.getName().equals("all")) {
                this.addModel(new All(this.schema, child));
                continue;
            }
            if (child.getName().equals("annotation")) continue;
            if (child.getName().equals("choice")) {
                this.addModel(new Choice(this.schema, child));
                continue;
            }
            if (child.getName().equals("element")) {
                this.addElement(new SchemaElement(this.schema, child));
                continue;
            }
            if (child.getName().equals("group")) {
                this.addModel(new Group(this.schema, child));
                continue;
            }
            if (child.getName().equals("sequence")) {
                this.addModel(new Sequence(this.schema, child));
                continue;
            }
            throw new SchemaException("<choice> must currently be followed by <sequence>, <all>, or <annotation>");
        }
    }

    public void writeSchema(Element element, boolean annotated) throws SchemaException {
        String xsdPrefix = Type.getXSDPrefix(element);
        Element sequence = element.addElement(xsdPrefix, "choice");
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].writeSchema(sequence, annotated);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.models.length) {
            this.models[i2].writeSchema(sequence, annotated);
            ++i2;
        }
    }

    public void setParentType(Type parentType) {
        this.parentType = parentType;
        this.setSchema(parentType.getSchema());
    }

    public void addElement(SchemaElement element) {
        this.elements = (SchemaElement[])ArrayUtil.addElement(this.elements, element);
    }

    public void addModel(IModel model) {
        this.models = (IModel[])ArrayUtil.addElement(this.models, model);
    }

    public SchemaElement getSchemaElement(String name) throws SchemaException {
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i].getName().equals(name)) {
                return this.elements[i];
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.models.length) {
            SchemaElement retval = this.models[i2].getSchemaElement(name);
            if (retval != null) {
                return retval;
            }
            ++i2;
        }
        return null;
    }

    public SchemaAttribute getSchemaAttribute(String name) throws SchemaException {
        int i = 0;
        while (i < this.models.length) {
            SchemaAttribute retval = this.models[i].getSchemaAttribute(name);
            if (retval != null) {
                return retval;
            }
            ++i;
        }
        return null;
    }

    public String getJavaName() throws SchemaException {
        return this.parentType.getJavaName();
    }

    public Class getJavaClass() throws SchemaException {
        return this.parentType.getJavaClass();
    }

    public void writeJava(JavaSource source) throws SchemaException {
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].writeJava(source);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.models.length) {
            this.models[i2].writeJava(source);
            ++i2;
        }
    }

    public void forceResolution() {
        int i = 0;
        while (i < this.elements.length) {
            try {
                this.elements[i].getType();
            }
            catch (SchemaException exception) {
                // empty catch block
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.models.length) {
            this.models[i2].forceResolution();
            ++i2;
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        int i = 0;
        while (i < this.elements.length) {
            this.elements[i].readObject(reader, value);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.models.length) {
            this.models[i2].readObject(reader, value);
            ++i2;
        }
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        int i = 0;
        while (i < this.elements.length) {
            writer.writeObject(this.elements[i], object);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.models.length) {
            this.models[i2].writeObject(writer, object);
            ++i2;
        }
    }
}

