/*
 * Decompiled with CFR 0.152.
 */
package electric.util.string;

import electric.util.encoding.XMLEncodings;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;

public final class Strings {
    public static String getString(String flag, String[] args, int index) {
        if (index >= args.length) {
            throw new IllegalArgumentException("missing argument to -" + flag);
        }
        return args[index];
    }

    public static String asJavaName(String string) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (i == 0 && Character.isJavaIdentifierStart(ch) || Character.isJavaIdentifierPart(ch)) {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getJavaPackage(String name) {
        int dot = name.lastIndexOf(46);
        return dot != -1 ? name.substring(0, dot) : null;
    }

    public static String getLocalJavaName(String name) {
        return Strings.tail(name, '.');
    }

    public static boolean hasBOM(byte[] bytes) {
        if (bytes.length < 2) {
            return false;
        }
        return bytes[0] == -1 && bytes[1] == -2 || bytes[0] == -2 && bytes[1] == -1;
    }

    public static boolean isUTF8(String encoding) {
        return encoding == null || encoding.equalsIgnoreCase("UTF-8") || encoding.equalsIgnoreCase("UTF8");
    }

    public static String toString(byte[] bytes) throws UnsupportedEncodingException {
        byte[] header = bytes;
        if (bytes.length > 100) {
            header = new byte[100];
            System.arraycopy(bytes, 0, header, 0, 100);
        }
        return new String(bytes, XMLEncodings.getJavaEncoding(header));
    }

    public static String extension(String path) {
        int slash = path.lastIndexOf(47);
        int dot = path.lastIndexOf(46);
        return dot > slash ? path.substring(dot + 1) : null;
    }

    public static String tail(String string, char delimiter) {
        int index = string.lastIndexOf(delimiter);
        return index == -1 ? string : string.substring(index + 1);
    }

    public static String head(String string, char delimiter) {
        int index = string.lastIndexOf(delimiter);
        return index == -1 ? string : string.substring(0, index);
    }

    public static String splice(String path1, String path2) {
        if (path2 == null || path2.length() == 0) {
            return path1;
        }
        if (path1.endsWith("/") && path2.startsWith("/")) {
            return path1 + path2.substring(1);
        }
        if (path1.endsWith("/") || path2.startsWith("/")) {
            return path1 + path2;
        }
        if (path1.length() > 0) {
            return path1 + "/" + path2;
        }
        return path2;
    }

    public static String replace(String string, String before, String after) {
        if (string.indexOf(before.charAt(0)) == -1) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        while (true) {
            int match;
            if ((match = string.indexOf(before, index)) == -1) {
                buffer.append(string.substring(index, string.length()));
                return buffer.toString();
            }
            buffer.append(string.substring(index, match)).append(after);
            index = match + before.length();
        }
    }

    public static String stripChar(String string, char charToStrip) {
        StringBuffer newString = new StringBuffer();
        char[] chars = string.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != charToStrip) {
                newString.append(chars[i]);
            }
            ++i;
        }
        return newString.toString();
    }

    public static String arrayToString(Object array) {
        int length = Array.getLength(array);
        if (length == 0) {
            return "()";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("( ");
        int i = 0;
        while (i < length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(Array.get(array, i));
            ++i;
        }
        return buffer.append(" )").toString();
    }

    public static String getURN(String string) {
        int index = string.lastIndexOf("/");
        return index == -1 ? string : string.substring(index + 1);
    }

    public static String getEndpoint(String string) {
        int index = string.lastIndexOf("/");
        return index == -1 ? "" : string.substring(0, index);
    }

    public static String toFilename(String name) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '.') {
                buffer.append(ch);
            } else {
                buffer.append('_');
                buffer.append(Integer.toString(ch));
                buffer.append('_');
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String fromFilename(String name) {
        int start = name.indexOf(95);
        if (start == -1) {
            return name;
        }
        int stop = name.indexOf(95, start + 1);
        char ch = (char)Integer.parseInt(name.substring(start + 1, stop));
        return name.substring(0, start) + ch + Strings.fromFilename(name.substring(stop + 1));
    }

    public static void substitute(String[][] query, String[][] post) {
        int i = 0;
        while (i < query.length) {
            String value = query[i][1];
            if (value.length() > 0 && value.charAt(0) == '$') {
                String key = value.substring(1, value.length());
                int j = 0;
                while (j < post.length) {
                    if (post[j][0].equals(key)) {
                        query[i][1] = post[j][1];
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static String getCapitalized(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static boolean getBoolean(String string, boolean defaultValue) {
        if (string == null) {
            return defaultValue;
        }
        if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1")) {
            return true;
        }
        if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("0")) {
            return false;
        }
        return defaultValue;
    }

    public static String stripQuotes(String quotedString) {
        if (quotedString != null && quotedString.length() > 2 && quotedString.startsWith("\"")) {
            return quotedString.substring(1, quotedString.length() - 1);
        }
        return quotedString;
    }

    public static boolean isInteger(String integer) {
        try {
            Integer.parseInt(integer);
            return true;
        }
        catch (NumberFormatException exception) {
            return false;
        }
    }
}

