/*
 * Decompiled with CFR 0.152.
 */
package electric.util.mime;

import electric.util.array.ArrayUtil;
import electric.util.array.ByteArray;
import electric.util.encoding.StringEncodings;
import electric.util.http.IHTTPConstants;
import electric.util.mime.IMIMEConstants;
import electric.util.mime.MIMEData;
import electric.util.mime.MIMEHeaders;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Vector;

public final class MIMEBuilder
implements IHTTPConstants,
IMIMEConstants {
    private static final byte[] EOL = StringEncodings.toProtocolEncoding("\r\n");
    private static final byte[] MIME_PART_BOUNDARY = StringEncodings.toProtocolEncoding("MIME_boundary" + System.currentTimeMillis());
    private static final byte[] MIME_PART_SEPARATOR = (byte[])ArrayUtil.addElements(StringEncodings.toProtocolEncoding("--"), MIME_PART_BOUNDARY);
    private static String startMimePart;
    private static String contentType;
    private SequenceInputStream sequenceStream;
    private int contentLength;

    public MIMEBuilder(MIMEData[] attachments, ByteArray byteArray, MIMEHeaders headers) throws IOException {
        this.contentLength = byteArray.length;
        int i = 0;
        while (i < attachments.length) {
            attachments[i].setDelimiter(MIME_PART_SEPARATOR);
            this.contentLength += attachments[i].getFormattedContentLength();
            ++i;
        }
        headers.addHeader("Content-Location", startMimePart);
        headers.setIntHeader("Content-Length", byteArray.length);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        headers.writeHeaders(output);
        byte[] headersBytes = output.toByteArray();
        this.contentLength += headersBytes.length;
        this.contentLength += MIME_PART_SEPARATOR.length * 2;
        this.contentLength += 2;
        this.contentLength += EOL.length * 4;
        this.sequenceStream = this.getSequenceInputStream(attachments, byteArray, headersBytes);
    }

    private SequenceInputStream getSequenceInputStream(MIMEData[] attachments, ByteArray byteArray, byte[] headers) throws IOException {
        Vector<InputStream> streams = new Vector<InputStream>();
        byte[] bytes1 = (byte[])ArrayUtil.addElements(EOL, MIME_PART_SEPARATOR);
        bytes1 = (byte[])ArrayUtil.addElements(bytes1, EOL);
        bytes1 = (byte[])ArrayUtil.addElements(bytes1, headers);
        bytes1 = (byte[])ArrayUtil.addElements(bytes1, EOL);
        streams.addElement(new ByteArrayInputStream(bytes1));
        streams.addElement(new ByteArrayInputStream(byteArray.bytes, byteArray.offset, byteArray.length));
        streams.addElement(new ByteArrayInputStream(EOL));
        int i = 0;
        while (i < attachments.length) {
            streams.addElement(attachments[i].getFormattedInputStream());
            ++i;
        }
        byte[] bytes2 = (byte[])ArrayUtil.addElements(MIME_PART_SEPARATOR, StringEncodings.toProtocolEncoding("--"));
        streams.addElement(new ByteArrayInputStream(bytes2));
        return new SequenceInputStream(streams.elements());
    }

    public InputStream getInputStream() {
        return this.sequenceStream;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public static void setRootContentId(String rootContentId) {
        startMimePart = rootContentId;
        MIMEBuilder.setMultipartContentType(rootContentId);
    }

    public static String getRootContentId() {
        return startMimePart;
    }

    private static void setMultipartContentType(String startMimePart) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Multipart/Related");
        buffer.append("; ");
        buffer.append("boundary=");
        buffer.append(StringEncodings.fromProtocolEncoding(MIME_PART_BOUNDARY));
        buffer.append("; ");
        buffer.append("type=");
        buffer.append("text/xml");
        buffer.append("; ");
        buffer.append("start=\"<");
        buffer.append(startMimePart);
        buffer.append(">\"");
        contentType = buffer.toString();
    }

    public String getContentType() {
        return contentType;
    }

    static {
        MIMEBuilder.setRootContentId("http://www.themindelectric.com/rootpart.xml");
    }
}

