/*
 * Decompiled with CFR 0.152.
 */
package electric.util.log;

import electric.util.log.ILogger;
import electric.util.log.Log;
import java.util.Date;

public abstract class Logger
implements ILogger {
    long mask;
    private boolean enabled = true;

    public Logger() {
        this(0L);
    }

    public Logger(long mask) {
        this.mask = mask;
    }

    public boolean isLogging(long mask) {
        return (this.mask & mask) != 0L;
    }

    public boolean isLogging(String category) {
        return this.isLogging(Log.getCode(category));
    }

    public long getMask() {
        return this.mask;
    }

    public void setMask(long mask) {
        this.mask = mask;
        Log.recalcMasks();
    }

    public synchronized void addMask(long mask) {
        this.mask |= mask;
        Log.recalcMasks();
    }

    public synchronized void removeMask(long mask) {
        this.mask &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        Log.recalcMasks();
    }

    public void startLogging(String category) {
        this.addMask(Log.getCode(category));
    }

    public void stopLogging(String category) {
        this.removeMask(Log.getCode(category));
    }

    public synchronized void disable() {
        this.enabled = false;
    }

    public synchronized void enable() {
        this.enabled = true;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public abstract void event(String var1, Object var2, Date var3);
}

