/*
 * Decompiled with CFR 0.152.
 */
package electric.util.license;

import electric.util.crypto.DESEncoding;
import electric.util.holder.java.lang.StringOut;
import electric.util.license.ILicenseConstants;
import electric.util.license.LicensingException;
import electric.util.product.ProductInfo;
import electric.util.string.Base64;
import electric.util.string.Strings;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;

public final class Codec
implements ILicenseConstants {
    private static final DateFormat dateFormat = DateFormat.getDateInstance(3);

    public Hashtable validate(String actCode, String userId, int productId, int majorVersion) throws LicensingException {
        char[] actCodeChars = actCode.toCharArray();
        int nodeLockLen = this.getLength(actCodeChars, actCodeChars.length - 3);
        String licenseInfo = new String(actCodeChars, nodeLockLen, actCodeChars.length - 3 - nodeLockLen);
        licenseInfo = Strings.stripChar(licenseInfo, '-');
        Hashtable constraints = this.getLicenseConstraints(licenseInfo, userId, productId, majorVersion);
        int nodeLockInfoLen = this.getLength(actCodeChars, 0);
        if (nodeLockInfoLen != 0) {
            String nodeLockInfo = new String(actCodeChars, 16, nodeLockInfoLen);
            try {
                DESEncoding decrypter = new DESEncoding(new String(actCodeChars, 3, this.getLength(actCodeChars, 3) + 3).getBytes("UTF8"));
                nodeLockInfo = new String(decrypter.decrypt(Base64.fromBase64(nodeLockInfo)), "UTF8").trim();
            }
            catch (UnsupportedEncodingException exception) {
                throw new LicensingException("unable to perform byte conversion " + exception.toString());
            }
            constraints.put("nodeLockInfo", nodeLockInfo);
        }
        return constraints;
    }

    private Hashtable getNodeLockInfo(String nodeLockInfo) {
        Hashtable<String, Object> nodeLock = new Hashtable<String, Object>();
        char[] nodeLockInfoChars = nodeLockInfo.toCharArray();
        int len = nodeLockInfoChars.length;
        int cpuCountLen = this.getLength(nodeLockInfoChars, 0);
        int ipAddrLen = this.getLength(nodeLockInfoChars, 3);
        int versionLen = this.getLength(nodeLockInfoChars, 6);
        int hostNameLen = this.getLength(nodeLockInfoChars, 9);
        int osTypeLen = this.getLength(nodeLockInfoChars, 12);
        int offset = len - cpuCountLen;
        int cpuCount = Integer.parseInt(new String(nodeLockInfoChars, offset, cpuCountLen));
        nodeLock.put("cpuCount", new Integer(cpuCount));
        int licenseType = Integer.parseInt(new String(nodeLockInfoChars, --offset, 1));
        nodeLock.put("licenseType", new Integer(licenseType));
        String ipAddress = new String(nodeLockInfoChars, offset -= ipAddrLen, ipAddrLen);
        nodeLock.put("ipAddress", ipAddress);
        String version = new String(nodeLockInfoChars, offset -= versionLen, versionLen);
        nodeLock.put("version", version);
        String hostName = new String(nodeLockInfoChars, offset -= hostNameLen, hostNameLen);
        nodeLock.put("hostName", hostName);
        String osType = new String(nodeLockInfoChars, offset -= osTypeLen, osTypeLen);
        nodeLock.put("os", osType);
        return nodeLock;
    }

    private Hashtable getLicenseConstraints(String activationCode, String userId, int productId, int majorVersion) {
        StringOut expDateHolder = new StringOut();
        StringOut userIdHolder = new StringOut();
        int len = this.getEncodedData(activationCode, expDateHolder, userIdHolder);
        if (!userIdHolder.value.equalsIgnoreCase(userId)) {
            throw new LicensingException(0);
        }
        expDateHolder.value = this.validateExpiration(expDateHolder.value);
        Integer conLimit = new Integer(this.getConnectionLimit(activationCode, len, productId, majorVersion));
        Hashtable<String, Object> constraints = new Hashtable<String, Object>();
        if (expDateHolder.value != null) {
            constraints.put("expirationDate", expDateHolder.value);
        }
        constraints.put("connectionLimit", conLimit);
        constraints.put("clientLicense", new Boolean(activationCode.charAt(2) == 'J' || activationCode.charAt(2) == '8'));
        int runtimeTimeout = this.getRuntimeTimeout(activationCode, len);
        if (runtimeTimeout > 0) {
            constraints.put("featureTimeout", new Integer(runtimeTimeout));
        }
        return constraints;
    }

    private int getEncodedData(String activationCode, StringOut expDateHolder, StringOut userIdHolder) throws LicensingException {
        char[] chars = activationCode.toCharArray();
        StringBuffer expDate = new StringBuffer();
        StringBuffer userId = new StringBuffer();
        int len = 0;
        try {
            len = Integer.parseInt(new String(chars, 0, 2), 16);
            boolean isExpDate = chars[2] - 56 >= 0 && chars[2] - 56 <= 1;
            len *= 2;
            int i = 0;
            while (i < len) {
                expDate.append(chars[3 + i]);
                userId.append(chars[4 + i]);
                i += 2;
            }
            String remainder = this.getRemainder(activationCode, len);
            if (isExpDate) {
                userId.append(remainder);
            } else {
                expDate.append(remainder);
            }
            expDateHolder.value = expDate.toString();
            userIdHolder.value = userId.toString();
            return len;
        }
        catch (Exception exception) {
            throw new LicensingException(0);
        }
    }

    private String getRemainder(String activationCode, int length) {
        char[] chars = activationCode.toCharArray();
        int remainderLen = Integer.parseInt(new String(chars, 3 + length, 1), 16);
        return new String(chars, 4 + length, remainderLen);
    }

    private String validateExpiration(String expDate) throws LicensingException {
        long expDateMills = Long.parseLong(expDate, 16);
        if (expDateMills < System.currentTimeMillis() && expDateMills != 1007186400000L) {
            throw new LicensingException(1);
        }
        return expDateMills == 1007186400000L ? null : dateFormat.format(new Date(expDateMills));
    }

    private int getConnectionLimit(String activationCode, int len, int productId, int majorVersion) throws LicensingException {
        char[] chars = activationCode.toCharArray();
        int remainderLen = this.getRemainder(activationCode, len).length();
        int crc = 0;
        int i = 3 + len + remainderLen;
        while (i >= 0) {
            int num = chars[i] >> productId;
            crc += num << majorVersion;
            --i;
        }
        int crcLen = Integer.parseInt(new String(chars, 4 + remainderLen + len, 2), 16);
        int rCrc = Integer.parseInt(new String(chars, 6 + len + remainderLen, crcLen), 16);
        if (rCrc % crc != 0) {
            throw new LicensingException(0);
        }
        return rCrc == crc ? -1 : rCrc / crc;
    }

    private int getRuntimeTimeout(String activationCode, int len) {
        char[] chars = activationCode.toCharArray();
        int remainderLen = this.getRemainder(activationCode, len).length();
        int crcLen = Integer.parseInt(new String(chars, 4 + remainderLen + len, 2), 16);
        int offset = 6 + remainderLen + len + crcLen;
        return Integer.parseInt(new String(chars, offset, chars.length - offset), 16);
    }

    public void printProperties(ProductInfo productInfo) {
        String expDate = (String)productInfo.getLicenseInfo().getProperty("expirationDate");
        System.out.println("\texpiration date  : " + (expDate == null ? "none" : expDate));
        Integer connLimit = (Integer)productInfo.getLicenseInfo().getProperty("connectionLimit");
        System.out.println("\tconnection limit : " + (connLimit == -1 ? "unlimited" : connLimit + " connections"));
    }

    private int getLength(char[] chars, int offset) {
        String str = new String(chars, offset, 3);
        return Integer.parseInt(str, 16);
    }
}

